/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.java.parser;

import antlr.CommonHiddenStreamToken;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.portal.tools.java.parser.JavaAnnotationFieldDefinition;
import com.liferay.portal.tools.java.parser.JavaBreakStatement;
import com.liferay.portal.tools.java.parser.JavaCatchStatement;
import com.liferay.portal.tools.java.parser.JavaClassCall;
import com.liferay.portal.tools.java.parser.JavaClassDefinition;
import com.liferay.portal.tools.java.parser.JavaConstructorCall;
import com.liferay.portal.tools.java.parser.JavaConstructorDefinition;
import com.liferay.portal.tools.java.parser.JavaContinueStatement;
import com.liferay.portal.tools.java.parser.JavaDoStatement;
import com.liferay.portal.tools.java.parser.JavaElseStatement;
import com.liferay.portal.tools.java.parser.JavaEnhancedForStatement;
import com.liferay.portal.tools.java.parser.JavaEnumConstantDefinition;
import com.liferay.portal.tools.java.parser.JavaEnumConstantDefinitions;
import com.liferay.portal.tools.java.parser.JavaFinallyStatement;
import com.liferay.portal.tools.java.parser.JavaForStatement;
import com.liferay.portal.tools.java.parser.JavaIfStatement;
import com.liferay.portal.tools.java.parser.JavaInstanceInitialization;
import com.liferay.portal.tools.java.parser.JavaLambdaExpression;
import com.liferay.portal.tools.java.parser.JavaMethodDefinition;
import com.liferay.portal.tools.java.parser.JavaReturnStatement;
import com.liferay.portal.tools.java.parser.JavaStaticInitialization;
import com.liferay.portal.tools.java.parser.JavaSynchronizedStatement;
import com.liferay.portal.tools.java.parser.JavaThrowStatement;
import com.liferay.portal.tools.java.parser.JavaTryStatement;
import com.liferay.portal.tools.java.parser.JavaVariableDefinition;
import com.liferay.portal.tools.java.parser.JavaWhileStatement;
import com.liferay.portal.tools.java.parser.Position;
import com.liferay.portal.tools.java.parser.util.JavaParserUtil;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParsedJavaTerm
implements Comparable<ParsedJavaTerm> {
    protected static final int DOUBLE_LINE_BREAK_REQUIRED = 0;
    protected static final int NO_ACTION_REQUIRED = 1;
    protected static final int SINGLE_LINE_BREAK_REQUIRED = 2;
    private static final Pattern _accessModifierPattern = Pattern.compile("\t(private|protected|public)\\s");
    private static final Pattern _variableNamePattern = Pattern.compile("\\s(\\w+)( =|;)");
    private final String _className;
    private boolean _containsCommentToken;
    private final String _content;
    private final Position _endPosition;
    private final String _followingNestedCodeBlockClassName;
    private ParsedJavaTerm _nextParsedJavaTerm;
    private CommonHiddenStreamToken _precedingCommentToken;
    private final String _precedingNestedCodeBlockClassName;
    private ParsedJavaTerm _previousParsedJavaTerm;
    private final Position _startPosition;

    public ParsedJavaTerm(String content, Position startPosition, Position endPosition, String className, String precedingNestedCodeBlockClassName, String followingNestedCodeBlockClassName) {
        this._content = content;
        this._startPosition = startPosition;
        this._endPosition = endPosition;
        this._className = className;
        this._precedingNestedCodeBlockClassName = precedingNestedCodeBlockClassName;
        this._followingNestedCodeBlockClassName = followingNestedCodeBlockClassName;
    }

    @Override
    public int compareTo(ParsedJavaTerm parsedJavaTerm) {
        return this._startPosition.compareTo(parsedJavaTerm.getStartPosition());
    }

    public boolean containsCommentToken() {
        return this._containsCommentToken;
    }

    public String getAccessModifier() {
        Matcher matcher = _accessModifierPattern.matcher(this._content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public String getClassName() {
        return this._className;
    }

    public String getContent() {
        return this._content;
    }

    public Position getEndPosition() {
        return this._endPosition;
    }

    public int getFollowingLineAction() {
        ParsedJavaTerm nextParsedJavaTerm = this.getNextParsedJavaTerm();
        if (nextParsedJavaTerm == null) {
            return 1;
        }
        CommonHiddenStreamToken precedingCommentToken = nextParsedJavaTerm.getPrecedingCommentToken();
        if (precedingCommentToken != null) {
            while (precedingCommentToken.getHiddenBefore() != null) {
                precedingCommentToken = precedingCommentToken.getHiddenBefore();
            }
            if (precedingCommentToken.getType() == 145 && StringUtil.startsWith(StringUtil.trim(precedingCommentToken.getText()), '*') || precedingCommentToken.getType() == 144 && StringUtil.startsWith(precedingCommentToken.getText(), ' ')) {
                return 0;
            }
            return 1;
        }
        if (nextParsedJavaTerm.getPrecedingLineAction() != 1) {
            return 1;
        }
        if (this._content.endsWith("{")) {
            if (this._followingNestedCodeBlockClassName != null) {
                return this._getOpenCurlyBraceFollowingLineAction(this._followingNestedCodeBlockClassName);
            }
            return this._getOpenCurlyBraceFollowingLineAction(this._className);
        }
        if (Objects.equals(StringUtil.trim(this._content), "}") || this._className.equals(JavaConstructorCall.class.getName()) || this._className.equals(JavaMethodDefinition.class.getName()) || this._className.equals(JavaEnumConstantDefinitions.class.getName()) || this._className.equals(JavaAnnotationFieldDefinition.class.getName())) {
            return 0;
        }
        return 1;
    }

    public ParsedJavaTerm getNextParsedJavaTerm() {
        return this._nextParsedJavaTerm;
    }

    public CommonHiddenStreamToken getPrecedingCommentToken() {
        return this._precedingCommentToken;
    }

    public int getPrecedingLineAction() {
        ParsedJavaTerm previousParsedJavaTerm = this.getPreviousParsedJavaTerm();
        if (this._precedingCommentToken != null) {
            if (previousParsedJavaTerm == null) {
                return 0;
            }
            if (this._precedingCommentToken.getType() == 144 && StringUtil.startsWith(this._precedingCommentToken.getText(), ' ')) {
                Position previousEndPosition = previousParsedJavaTerm.getEndPosition();
                if (previousEndPosition.getLineNumber() == this._precedingCommentToken.getLine()) {
                    return 1;
                }
                return 0;
            }
            if (this._precedingCommentToken.getType() == 145 && StringUtil.startsWith(StringUtil.trim(this._precedingCommentToken.getText()), '*') && !StringUtil.startsWith(StringUtil.trim(this._content), "}")) {
                return 2;
            }
            return 1;
        }
        if (previousParsedJavaTerm == null) {
            return 1;
        }
        if (this._className.equals(JavaVariableDefinition.class.getName()) && this._className.equals(previousParsedJavaTerm.getClassName())) {
            return this._getBetweenVariableDefinitionsLineAction(previousParsedJavaTerm);
        }
        if (StringUtil.endsWith(previousParsedJavaTerm.getContent(), '{')) {
            return 1;
        }
        if (StringUtil.startsWith(StringUtil.trim(this._content), "}")) {
            if (this._precedingNestedCodeBlockClassName != null) {
                return this._getCloseCurlyBracePrecedingLineAction(this._precedingNestedCodeBlockClassName);
            }
            return this._getCloseCurlyBracePrecedingLineAction(this._className);
        }
        if (this._className.equals(JavaAnnotationFieldDefinition.class.getName()) || this._className.equals(JavaBreakStatement.class.getName()) || this._className.equals(JavaConstructorDefinition.class.getName()) || this._className.equals(JavaContinueStatement.class.getName()) || this._className.equals(JavaDoStatement.class.getName()) || this._className.equals(JavaEnhancedForStatement.class.getName()) || this._className.equals(JavaEnumConstantDefinitions.class.getName()) || this._className.equals(JavaForStatement.class.getName()) || this._className.equals(JavaIfStatement.class.getName()) || this._className.equals(JavaMethodDefinition.class.getName()) || this._className.equals(JavaReturnStatement.class.getName()) || this._className.equals(JavaStaticInitialization.class.getName()) || this._className.equals(JavaSynchronizedStatement.class.getName()) || this._className.equals(JavaThrowStatement.class.getName()) || this._className.equals(JavaTryStatement.class.getName())) {
            return 0;
        }
        if (this._className.equals(JavaCatchStatement.class.getName()) || this._className.equals(JavaElseStatement.class.getName()) || this._className.equals(JavaFinallyStatement.class.getName())) {
            return 2;
        }
        if (this._className.equals(JavaWhileStatement.class.getName())) {
            if (this._content.endsWith("{")) {
                return 0;
            }
            if (Objects.equals(previousParsedJavaTerm.getClassName(), JavaDoStatement.class.getName())) {
                return 2;
            }
        }
        return 1;
    }

    public ParsedJavaTerm getPreviousParsedJavaTerm() {
        return this._previousParsedJavaTerm;
    }

    public Position getStartPosition() {
        return this._startPosition;
    }

    public String getVariableName() {
        Matcher matcher = _variableNamePattern.matcher(this._content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public void setContainsCommentToken(boolean containsCommentToken) {
        this._containsCommentToken = containsCommentToken;
    }

    public void setNextParsedJavaTerm(ParsedJavaTerm nextParsedJavaTerm) {
        this._nextParsedJavaTerm = nextParsedJavaTerm;
    }

    public void setPrecedingCommentToken(CommonHiddenStreamToken precedingCommentToken) {
        this._precedingCommentToken = precedingCommentToken;
    }

    public void setPreviousParsedJavaTerm(ParsedJavaTerm previousParsedJavaTerm) {
        this._previousParsedJavaTerm = previousParsedJavaTerm;
    }

    private boolean _containsUnquoted(String s, String text) {
        int x = -1;
        do {
            if ((x = s.indexOf(text, x + 1)) != -1) continue;
            return false;
        } while (ToolsUtil.isInsideQuotes(s, x));
        return true;
    }

    private int _getBetweenVariableDefinitionsLineAction(ParsedJavaTerm previousJavaTerm) {
        if (this._followingNestedCodeBlockClassName != null || previousJavaTerm._followingNestedCodeBlockClassName != null || previousJavaTerm._precedingNestedCodeBlockClassName != null || previousJavaTerm.getPrecedingCommentToken() != null) {
            return 1;
        }
        String accessModifier = this.getAccessModifier();
        String previousAccessModifier = previousJavaTerm.getAccessModifier();
        if (accessModifier == null && previousAccessModifier == null) {
            return 1;
        }
        if (!Objects.equals(accessModifier, previousAccessModifier) || previousJavaTerm.getPrecedingCommentToken() != null || StringUtil.startsWith(StringUtil.trim(this._content), '@') || StringUtil.startsWith(StringUtil.trim(previousJavaTerm.getContent()), '@')) {
            return 0;
        }
        String previousContent = previousJavaTerm.getContent();
        if (previousContent.matches("(?s).*\\sstatic\\s.*") ^ this._content.matches("(?s).*\\sstatic\\s.*")) {
            return 0;
        }
        String previousVariableName = previousJavaTerm.getVariableName();
        String variableName = this.getVariableName();
        if (StringUtil.isUpperCase(previousVariableName) && !StringUtil.isLowerCase(previousVariableName) || StringUtil.isUpperCase(variableName) && !StringUtil.isLowerCase(variableName)) {
            return 0;
        }
        if (previousContent.matches("(?s).*\\sstatic\\s.*") && (previousVariableName.equals("_instance") || previousVariableName.equals("_log") || previousVariableName.equals("_logger"))) {
            return 0;
        }
        return 2;
    }

    private int _getCloseCurlyBracePrecedingLineAction(String className) {
        ParsedJavaTerm previousParsedJavaTerm;
        String previousClassName;
        if (className.equals(JavaEnumConstantDefinition.class.getName()) || className.equals(JavaClassDefinition.class.getName())) {
            return 0;
        }
        if (className.equals(JavaClassCall.class.getName()) && !(previousClassName = (previousParsedJavaTerm = this.getPreviousParsedJavaTerm()).getClassName()).equals(JavaInstanceInitialization.class.getName())) {
            return 0;
        }
        return 2;
    }

    private String _getIndent(String s, int lineNumber) {
        int x = -1;
        for (int i = 1; i < lineNumber; ++i) {
            x = s.indexOf(10, x + 1);
        }
        StringBundler sb = new StringBundler();
        int i = x + 1;
        while (s.charAt(i) == '\t') {
            sb.append('\t');
            ++i;
        }
        return sb.toString();
    }

    private int _getOpenCurlyBraceFollowingLineAction(String className) {
        if (className.equals(JavaLambdaExpression.class.getName())) {
            String lastLine;
            if (this._content.endsWith(") -> {") && !(lastLine = StringUtil.trim(JavaParserUtil.getLastLine(this._content))).contains("(")) {
                return 0;
            }
            return 2;
        }
        ParsedJavaTerm nextParsedJavaTerm = this.getNextParsedJavaTerm();
        String trimmedNextJavaTermContent = StringUtil.trim(nextParsedJavaTerm.getContent());
        if (trimmedNextJavaTermContent.startsWith("}")) {
            return 2;
        }
        if (className.equals(JavaClassDefinition.class.getName()) || className.equals(JavaEnumConstantDefinition.class.getName())) {
            return 0;
        }
        if (Objects.equals(nextParsedJavaTerm.getClassName(), JavaInstanceInitialization.class.getName())) {
            String lastLine = StringUtil.trim(JavaParserUtil.getLastLine(this._content));
            if (lastLine.startsWith("new ") || this._containsUnquoted(lastLine, " new ")) {
                return 2;
            }
            return 0;
        }
        int lineCount = StringUtil.count(this._content, '\n') + 1;
        if (this._precedingNestedCodeBlockClassName != null || lineCount > 1 && !Objects.equals(this._getIndent(this._content, 1), this._getIndent(this._content, lineCount))) {
            return 0;
        }
        String lastLine = StringUtil.trim(JavaParserUtil.getLastLine(this._content));
        int x = lastLine.lastIndexOf(" new ");
        if (x != -1 && !ToolsUtil.isInsideQuotes(lastLine, x) && ToolsUtil.getLevel(lastLine.substring(x)) == 0) {
            return 0;
        }
        return 2;
    }
}

