/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.parser;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.JavaImportsFormatter;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaConstructor;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaStaticBlock;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;
import com.liferay.source.formatter.parser.ParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaClassParser {
    private static final Pattern _anonymousClassPattern = Pattern.compile("\n\t+(\\S.* )?new ((.|\\(\n|\\w\n)*\\)) \\{\n\n");
    private static final Pattern _implementsPattern = Pattern.compile("(\\A|\\s)implements\\s");
    private static final Pattern _javaTermEndPattern = Pattern.compile("[;}]\\s*?\n");
    private static final Pattern _javaTermStartLinePattern = Pattern.compile(".*?[{;]\\s*?\n", 32);

    public static List<JavaClass> parseAnonymousClasses(String content) throws IOException, ParseException {
        ArrayList<JavaClass> anonymousClasses = new ArrayList<JavaClass>();
        Matcher matcher = _anonymousClassPattern.matcher(content);
        while (matcher.find()) {
            String classContent;
            String s = content.substring(matcher.start(2), matcher.end());
            if (JavaSourceUtil.getLevel(s) != 0) continue;
            int x = matcher.start() + 1;
            int y = matcher.end();
            while (JavaSourceUtil.getLevel(classContent = content.substring(x, y), "{", "}") != 0) {
                ++y;
            }
            int lineNumber = SourceUtil.getLineNumber(content, matcher.start(2));
            anonymousClasses.add(JavaClassParser._parseJavaClass("", classContent, lineNumber, "private", false, false, false, false, true));
        }
        return anonymousClasses;
    }

    public static JavaClass parseJavaClass(String fileName, String content) throws IOException, ParseException {
        String[] importLines;
        String className = JavaSourceUtil.getClassName(fileName);
        Pattern pattern = Pattern.compile(StringBundler.concat("\n(public\\s+)?(abstract\\s+)?(final\\s+)?@?", "(class|enum|interface)\\s+", className, "([<|\\s][^\\{]*)\\{"));
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            throw new ParseException("Parsing error");
        }
        int x = matcher.start() + 1;
        int y = x + 1;
        do {
            if ((y = content.lastIndexOf("\n\n", y - 1)) != -1) continue;
            throw new ParseException("Parsing error");
        } while (SourceUtil.getLevel(content.substring(y, x)) != 0);
        int lineNumber = SourceUtil.getLineNumber(content, y + 2);
        String classContent = content.substring(y + 2);
        boolean isAbstract = false;
        if (matcher.group(2) != null) {
            isAbstract = true;
        }
        boolean isEnum = false;
        boolean isInterface = false;
        if (matcher.group(4) != null) {
            String token = matcher.group(4);
            if (token.equals("enum")) {
                isEnum = true;
            } else if (token.equals("interface")) {
                isInterface = true;
            }
        }
        JavaClass javaClass = JavaClassParser._parseJavaClass(className, classContent, lineNumber, "public", isAbstract, false, isEnum, isInterface, false);
        javaClass.setPackageName(JavaSourceUtil.getPackageName(content));
        for (String importLine : importLines = StringUtil.splitLines(JavaImportsFormatter.getImports(content))) {
            if (!Validator.isNotNull(importLine)) continue;
            javaClass.addImport(importLine.substring(7, importLine.length() - 1));
        }
        return JavaClassParser._parseExtendsImplements(javaClass, StringUtil.trim(matcher.group(5)));
    }

    private static String _getClassName(String line) {
        int pos = line.indexOf(" extends ");
        if (pos == -1) {
            pos = line.indexOf(" implements ");
        }
        if (pos == -1) {
            pos = line.indexOf(123);
        }
        if (pos != -1) {
            line = line.substring(0, pos);
        }
        if ((pos = line.indexOf(60)) != -1) {
            line = line.substring(0, pos);
        }
        line = line.trim();
        pos = line.lastIndexOf(32);
        return line.substring(pos + 1);
    }

    private static int _getCommentEndLineNumber(String classContent, int lineNumber) {
        String line;
        while (!(line = SourceUtil.getLine(classContent, lineNumber)).endsWith("*/")) {
            ++lineNumber;
        }
        return lineNumber;
    }

    private static String _getConstructorOrMethodName(String line, int pos) {
        line = line.substring(0, pos);
        int x = line.lastIndexOf(32);
        return line.substring(x + 1);
    }

    private static JavaTerm _getJavaTerm(String metadata, String javaTermContent, int lineNumber) throws IOException, ParseException {
        Matcher matcher = _javaTermStartLinePattern.matcher(javaTermContent);
        if (!matcher.find()) {
            return null;
        }
        String startLine = StringUtil.trim(matcher.group());
        startLine = StringUtil.replace(startLine, new String[]{"\t", "(\n", "\n", " synchronized "}, new String[]{"", "(", " ", " "});
        javaTermContent = metadata + javaTermContent;
        if (startLine.startsWith("static {")) {
            return new JavaStaticBlock(javaTermContent, lineNumber);
        }
        String accessModifier = "default";
        for (String curAccessModifier : JavaTerm.ACCESS_MODIFIERS) {
            if (!startLine.startsWith(curAccessModifier)) continue;
            accessModifier = curAccessModifier;
            break;
        }
        boolean isAbstract = SourceUtil.containsUnquoted(startLine, " abstract ");
        boolean isEnum = SourceUtil.containsUnquoted(startLine, " enum ");
        boolean isInterface = SourceUtil.containsUnquoted(startLine, " interface ");
        boolean isStatic = SourceUtil.containsUnquoted(startLine, " static ");
        int x = startLine.indexOf(61);
        int y = startLine.indexOf(40);
        if (SourceUtil.containsUnquoted(startLine, " @interface ") || SourceUtil.containsUnquoted(startLine, " class ") || SourceUtil.containsUnquoted(startLine, " enum ") || SourceUtil.containsUnquoted(startLine, " interface ")) {
            return JavaClassParser._parseJavaClass(JavaClassParser._getClassName(startLine), javaTermContent, lineNumber, accessModifier, isAbstract, isStatic, isEnum, isInterface, false);
        }
        if (x > 0 && (y == -1 || y > x) || startLine.endsWith(";") && y == -1) {
            return new JavaVariable(JavaClassParser._getVariableName(startLine), javaTermContent, accessModifier, lineNumber, isAbstract, isStatic);
        }
        if (y == -1) {
            return null;
        }
        int spaceCount = StringUtil.count(startLine.substring(0, y), ' ');
        if (isStatic || spaceCount > 1 || accessModifier.equals("default") && spaceCount > 0) {
            return new JavaMethod(JavaClassParser._getConstructorOrMethodName(startLine, y), javaTermContent, accessModifier, lineNumber, isAbstract, isStatic);
        }
        if (spaceCount == 1 || accessModifier.equals("default") && spaceCount == 0) {
            return new JavaConstructor(JavaClassParser._getConstructorOrMethodName(startLine, y), javaTermContent, accessModifier, lineNumber, isAbstract, isStatic);
        }
        return null;
    }

    private static int _getJavaTermEndLineNumber(String classContent, int lineNumber) {
        int x = SourceUtil.getLineStartPos(classContent, lineNumber);
        String s = classContent.substring(x);
        Matcher matcher = _javaTermEndPattern.matcher(s);
        while (matcher.find()) {
            String javaTermContent = s.substring(0, matcher.end());
            if (SourceUtil.getLevel(javaTermContent, "{", "}") != 0) continue;
            return lineNumber + StringUtil.count(javaTermContent, "\n") - 1;
        }
        return -1;
    }

    private static int _getMatchingEndLineNumber(String classContent, int lineNumber, String increaseLevelString, String decreaseLevelString) {
        int level = 0;
        String line;
        while ((level += SourceUtil.getLevel(line = SourceUtil.getLine(classContent, lineNumber), increaseLevelString, decreaseLevelString)) != 0) {
            ++lineNumber;
        }
        return lineNumber;
    }

    private static String _getVariableName(String line) {
        int x = line.indexOf(61);
        int y = line.lastIndexOf(32);
        if (x != -1) {
            line = line.substring(0, x);
            line = StringUtil.trim(line);
            y = line.lastIndexOf(32);
            return line.substring(y + 1);
        }
        if (line.endsWith(";")) {
            return line.substring(y + 1, line.length() - 1);
        }
        return "";
    }

    private static JavaClass _parseExtendsImplements(JavaClass javaClass, String s) throws ParseException {
        int x;
        if (SourceUtil.getLevel(s, "<", ">") != 0) {
            throw new ParseException("Parsing error around class declaration");
        }
        while ((x = s.indexOf("<")) != -1) {
            int y = x;
            while (SourceUtil.getLevel(s.substring(x, (y = s.indexOf(">", y + 1)) + 1), "<", ">") != 0) {
            }
            s = StringUtil.trim(s.substring(0, x) + s.substring(y + 1));
        }
        Matcher matcher = _implementsPattern.matcher(s);
        if (matcher.find()) {
            javaClass.addImplementedClassNames(StringUtil.split(s.substring(matcher.end())));
            s = StringUtil.trim(s.substring(0, matcher.start()));
        }
        if (s.startsWith("extends")) {
            javaClass.addExtendedClassNames(StringUtil.split(s.substring(7)));
        }
        return javaClass;
    }

    private static JavaClass _parseJavaClass(String className, String classContent, int classLineNumber, String accessModifier, boolean isAbstract, boolean isStatic, boolean isEnum, boolean isInterface, boolean anonymous) throws IOException, ParseException {
        String line;
        JavaClass javaClass = new JavaClass(className, classContent, accessModifier, classLineNumber, isAbstract, isStatic, isInterface, anonymous);
        int lineNumber = 0;
        int annotationLevel = 0;
        int level = 0;
        while ((annotationLevel += SourceUtil.getLevel(line = SourceUtil.getLine(classContent, ++lineNumber))) != 0 || (level += SourceUtil.getLevel(line, "{", "}")) == 0) {
        }
        if (isEnum) {
            do {
                if ((level += SourceUtil.getLevel(line = StringUtil.trim(SourceUtil.getLine(classContent, ++lineNumber)), "{", "}")) != 0) continue;
                return javaClass;
            } while (!line.endsWith(";") || level != 1);
        }
        int javaTermLineNumber = -1;
        String line2;
        while ((line2 = StringUtil.trim(SourceUtil.getLine(classContent, ++lineNumber))) != null && !line2.equals("}")) {
            if (line2.equals("") || line2.startsWith("//")) continue;
            if (line2.equals("/*") || line2.matches("/\\*[^*].*")) {
                lineNumber = JavaClassParser._getCommentEndLineNumber(classContent, lineNumber);
                continue;
            }
            if (line2.equals("{")) {
                lineNumber = JavaClassParser._getMatchingEndLineNumber(classContent, lineNumber, "{", "}");
                continue;
            }
            if (javaTermLineNumber == -1) {
                javaTermLineNumber = lineNumber;
            }
            if (line2.startsWith("@")) {
                lineNumber = JavaClassParser._getMatchingEndLineNumber(classContent, lineNumber, "(", ")");
                continue;
            }
            if (line2.startsWith("/**")) {
                lineNumber = JavaClassParser._getCommentEndLineNumber(classContent, lineNumber);
                continue;
            }
            int x = SourceUtil.getLineStartPos(classContent, javaTermLineNumber);
            int y = SourceUtil.getLineStartPos(classContent, lineNumber);
            String metadata = classContent.substring(x, y);
            int javaTermEndLineNumber = JavaClassParser._getJavaTermEndLineNumber(classContent, lineNumber);
            if (javaTermEndLineNumber == -1) {
                throw new ParseException("Parsing error at line '" + StringUtil.trim(line2) + "'");
            }
            int z = SourceUtil.getLineStartPos(classContent, javaTermEndLineNumber + 1);
            String javaTermContent = classContent.substring(y, z);
            JavaTerm javaTerm = JavaClassParser._getJavaTerm(metadata, javaTermContent, classLineNumber + javaTermLineNumber - 1);
            if (javaTerm == null) {
                throw new ParseException("Parsing error at line '" + StringUtil.trim(line2) + "'");
            }
            javaClass.addChildJavaTerm(javaTerm);
            javaTermLineNumber = -1;
            lineNumber = javaTermEndLineNumber;
        }
        return javaClass;
    }
}

