/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class ValidatorIsNullCheck
extends BaseCheck {
    private static final String _MSG_INVALID_METHOD_NAME = "method.invalidName";
    private static final String _MSG_RESERVED_METHOD = "method.reserved";

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        this._checkMethod(detailAST, "Validator", "isNotNull");
        this._checkMethod(detailAST, "Validator", "isNull");
    }

    private void _checkMethod(DetailAST detailAST, String className, String methodName) {
        List<DetailAST> methodCallASTList = DetailASTUtil.getMethodCalls(detailAST, className, methodName);
        for (DetailAST methodCallAST : methodCallASTList) {
            DetailAST typeAST;
            DetailAST elistAST = methodCallAST.findFirstToken(34);
            DetailAST expressionAST = elistAST.findFirstToken(28);
            DetailAST childAST = expressionAST.getFirstChild();
            if (childAST.getType() == 137) {
                this.log(methodCallAST, _MSG_INVALID_METHOD_NAME, new Object[]{StringBundler.concat(className, ".", methodName, "(long)")});
                continue;
            }
            if (childAST.getType() != 58 || (typeAST = DetailASTUtil.getVariableTypeAST(methodCallAST, childAST.getText())) == null) continue;
            childAST = typeAST.getFirstChild();
            if (childAST.getType() == 54 || childAST.getType() == 56) {
                this.log(methodCallAST, _MSG_INVALID_METHOD_NAME, new Object[]{StringBundler.concat(className, ".", methodName, "(long)")});
                continue;
            }
            String typeName = DetailASTUtil.getTypeName(typeAST, true);
            if (!Validator.isNotNull(typeName) || typeName.equals("Long") || typeName.equals("Object") || typeName.equals("Serializable") || typeName.equals("String")) continue;
            this.log(methodCallAST, _MSG_RESERVED_METHOD, new Object[]{StringBundler.concat(className, ".", methodName)});
        }
    }
}

