/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReferenceAnnotationCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_GREEDY_POLICY_OPTION = "greedy.policy.option.incorrect";
    private static final String _MSG_MISSING_DYNAMIC_POLICY_UNBIND = "unbind.dynamic.policy.missing";
    private static final String _MSG_MISSING_STATIC_POLICY_UNBIND = "unbind.static.policy.missing";
    private static final String _MSG_MISSING_VOLATILE = "volatile.missing";
    private static final String _MSG_MOVE_REFERENCE = "reference.move";
    private static final String _MSG_REDUNDANT_DEFAULT_UNBIND = "default.unbind.redundant";
    private static final String _NO_UNBIND = "\"-\"";
    private static final String _POLICY_DYNAMIC = "DYNAMIC";
    private static final String _POLICY_OPTION_GREEDY = "GREEDY";
    private static final String _POLICY_OPTION_RELUCTANT = "RELUCTANT";
    private static final String _POLICY_STATIC = "STATIC";
    private static final Pattern _referenceMethodContentPattern = Pattern.compile("^(\\w+) =\\s+\\w+;$");

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        if (parentAST != null) {
            return;
        }
        List<String> importNames = DetailASTUtil.getImportNames(detailAST);
        if (!importNames.contains("org.osgi.service.component.annotations.Reference")) {
            return;
        }
        List<DetailAST> detailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 9, 10);
        for (DetailAST curDetailAST : detailASTList) {
            this._checkReferenceAnnotation(curDetailAST);
        }
    }

    private void _checkDynamicMethod(DetailAST classDefAST, DetailAST methodDefAST, String methodName, String defaultUnbindMethodName) {
        String methodBody = this._getMethodBody(methodDefAST);
        Matcher matcher = _referenceMethodContentPattern.matcher(StringUtil.trim(methodBody));
        if (!matcher.find()) {
            if (!this._containsMethod(classDefAST, defaultUnbindMethodName)) {
                this.log(methodDefAST, _MSG_MISSING_DYNAMIC_POLICY_UNBIND, new Object[0]);
            }
            return;
        }
        String variableName = matcher.group(1);
        List<DetailAST> variableDefASTList = DetailASTUtil.getAllChildTokens(classDefAST, true, 10);
        for (DetailAST variableDefAST : variableDefASTList) {
            DetailAST identAST = variableDefAST.findFirstToken(58);
            if (!variableName.equals(identAST.getText())) continue;
            if (AnnotationUtil.containsAnnotation((DetailAST)variableDefAST, (String)"Reference")) {
                return;
            }
            DetailAST modifiersAST = variableDefAST.findFirstToken(5);
            if (modifiersAST.branchContains(64)) continue;
            this.log(methodDefAST, _MSG_MOVE_REFERENCE, new Object[]{methodName, variableName});
        }
    }

    private void _checkGreedyOption(DetailAST annotationAST, String policyName) {
        String policyOptionName = this._getAnnotationMemberValue(annotationAST, "policyOption", _POLICY_OPTION_RELUCTANT);
        if (policyOptionName.endsWith(_POLICY_OPTION_GREEDY) && policyName.endsWith(_POLICY_STATIC)) {
            this.log(annotationAST, _MSG_INCORRECT_GREEDY_POLICY_OPTION, new Object[0]);
        }
    }

    private void _checkReferenceAnnotation(DetailAST detailAST) {
        DetailAST annotationAST = AnnotationUtil.getAnnotation((DetailAST)detailAST, (String)"Reference");
        if (annotationAST == null) {
            return;
        }
        String policyName = this._getAnnotationMemberValue(annotationAST, "policy", _POLICY_STATIC);
        this._checkGreedyOption(annotationAST, policyName);
        if (detailAST.getType() == 10) {
            this._checkVolatileVariable(detailAST, policyName);
            return;
        }
        DetailAST classDefAST = DetailASTUtil.getParentWithTokenType(detailAST, 14);
        if (classDefAST == null) {
            return;
        }
        String unbindName = this._getAnnotationMemberValue(annotationAST, "unbind", null);
        DetailAST identAST = detailAST.findFirstToken(58);
        String methodName = identAST.getText();
        String defaultUnbindMethodName = this._getDefaultUnbindMethodName(methodName);
        this._checkUnbind(classDefAST, defaultUnbindMethodName, unbindName, policyName, annotationAST.getLineNo());
        if (policyName.endsWith(_POLICY_DYNAMIC) && unbindName == null) {
            this._checkDynamicMethod(classDefAST, detailAST, methodName, defaultUnbindMethodName);
        }
    }

    private void _checkUnbind(DetailAST classDefAST, String defaultUnbindMethodName, String unbindName, String policyName, int lineNo) {
        if (unbindName == null) {
            if (policyName.endsWith(_POLICY_STATIC) && !this._containsMethod(classDefAST, defaultUnbindMethodName)) {
                this.log(lineNo, _MSG_MISSING_STATIC_POLICY_UNBIND, new Object[]{_NO_UNBIND});
            }
        } else if (unbindName.equals("\"" + defaultUnbindMethodName + "\"")) {
            this.log(lineNo, _MSG_REDUNDANT_DEFAULT_UNBIND, new Object[0]);
        } else if (unbindName.equals(_NO_UNBIND) && policyName.endsWith(_POLICY_DYNAMIC)) {
            this.log(lineNo, _MSG_MISSING_DYNAMIC_POLICY_UNBIND, new Object[0]);
        }
    }

    private void _checkVolatileVariable(DetailAST variableDefAST, String policyName) {
        if (!policyName.endsWith(_POLICY_DYNAMIC)) {
            return;
        }
        DetailAST modifiersAST = variableDefAST.findFirstToken(5);
        if (!modifiersAST.branchContains(68)) {
            DetailAST identAST = variableDefAST.findFirstToken(58);
            this.log(identAST, _MSG_MISSING_VOLATILE, new Object[]{identAST.getText()});
        }
    }

    private boolean _containsMethod(DetailAST classDefAST, String methodName) {
        List<DetailAST> methodDefASTList = DetailASTUtil.getAllChildTokens(classDefAST, true, 9);
        for (DetailAST methodDefAST : methodDefASTList) {
            DetailAST identAST = methodDefAST.findFirstToken(58);
            if (!methodName.equals(identAST.getText())) continue;
            return true;
        }
        return false;
    }

    private String _getAnnotationMemberValue(DetailAST anontationAST, String name, String defaultValue) {
        List<DetailAST> annotationMemberValuePairASTList = DetailASTUtil.getAllChildTokens(anontationAST, false, 160);
        for (DetailAST annotationMemberValuePairAST : annotationMemberValuePairASTList) {
            DetailAST identAST = annotationMemberValuePairAST.findFirstToken(58);
            String annotationMemberName = identAST.getText();
            if (!annotationMemberName.equals(name)) continue;
            DetailAST expressionAST = annotationMemberValuePairAST.findFirstToken(28);
            if (expressionAST == null) {
                return null;
            }
            FullIdent expressionIdent = FullIdent.createFullIdentBelow((DetailAST)expressionAST);
            return expressionIdent.getText();
        }
        return defaultValue;
    }

    private String _getDefaultUnbindMethodName(String methodName) {
        if (methodName.startsWith("add")) {
            return StringUtil.replaceFirst(methodName, "add", "remove");
        }
        return "un" + methodName;
    }

    private String _getMethodBody(DetailAST methodDefAST) {
        DetailAST slistAST = methodDefAST.findFirstToken(7);
        int start = DetailASTUtil.getStartLine(slistAST);
        int end = DetailASTUtil.getEndLine(slistAST);
        StringBundler sb = new StringBundler((end - start - 1) * 2);
        for (int i = start + 1; i < end; ++i) {
            sb.append(this.getLine(i - 1));
            sb.append("\n");
        }
        return sb.toString();
    }
}

