/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.checks.BaseEnumConstantCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class EnumConstantDividerCheck
extends BaseEnumConstantCheck {
    private static final String _MSG_UNNECESSARY_EMPTY_LINE = "empty.line.unnecessary";

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST nextEnumConstantDefAST = this.getNextEnumConstantDefAST(detailAST);
        if (nextEnumConstantDefAST != null) {
            this._checkDivider(detailAST, nextEnumConstantDefAST);
        }
    }

    private void _checkDivider(DetailAST enumConstantDefAST1, DetailAST enumConstantDefAST2) {
        int startLineConstant2;
        int endLineConstant1 = DetailASTUtil.getEndLine(enumConstantDefAST1);
        if (endLineConstant1 == (startLineConstant2 = DetailASTUtil.getStartLine(enumConstantDefAST2))) {
            return;
        }
        String nextLine = this.getLine(endLineConstant1);
        String nextNextLine = StringUtil.trim(this.getLine(endLineConstant1 + 1));
        if (Validator.isNull(nextLine) && !nextNextLine.startsWith("/")) {
            this.log(endLineConstant1 + 1, _MSG_UNNECESSARY_EMPTY_LINE, new Object[0]);
        }
    }
}

