/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.StringConcatenationCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.List;

public class AppendCheck
extends StringConcatenationCheck {
    private static final String _MSG_INCORRECT_LINE_BREAK = "line.break.incorrect";
    private static final String _MSG_INCORRECT_PLUS = "plus.incorrect";

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<DetailAST> methodCallASTList = DetailASTUtil.getMethodCalls(detailAST, "append");
        boolean previousParameterIsLiteralString = false;
        for (int i = 0; i < methodCallASTList.size(); ++i) {
            DetailAST previousParameterDetailAST;
            DetailAST parameterDetailAST;
            String variableName;
            DetailAST methodCallAST = methodCallASTList.get(i);
            String variableTypeName = DetailASTUtil.getVariableTypeName(methodCallAST, variableName = DetailASTUtil.getVariableName(methodCallAST), false);
            if (!variableTypeName.equals("StringBundler") || (parameterDetailAST = this._getParameterDetailAST(methodCallAST)) == null) continue;
            this._checkPlusOperator(parameterDetailAST);
            if (parameterDetailAST.getType() != 139) {
                previousParameterIsLiteralString = false;
                continue;
            }
            if (!previousParameterIsLiteralString) {
                previousParameterIsLiteralString = true;
                continue;
            }
            DetailAST previousMethodCallAST = methodCallASTList.get(i - 1);
            if (!variableName.equals(DetailASTUtil.getVariableName(previousMethodCallAST)) || this._containsMethodCall(detailAST, variableName, "setIndex", "setStringAt") || (previousParameterDetailAST = this._getParameterDetailAST(previousMethodCallAST)) == null || previousParameterDetailAST.getType() != 139) continue;
            this._checkLiteralStrings(methodCallAST, previousMethodCallAST, parameterDetailAST.getText(), previousParameterDetailAST.getText());
        }
    }

    private void _checkLiteralStrings(DetailAST methodCallAST, DetailAST previousMethodCallAST, String literalStringValue, String previousLiteralStringValue) {
        if (DetailASTUtil.getEndLine(previousMethodCallAST) != methodCallAST.getLineNo() - 1) {
            return;
        }
        if ((previousLiteralStringValue = previousLiteralStringValue.substring(1, previousLiteralStringValue.length() - 1)).endsWith("\\n")) {
            return;
        }
        literalStringValue = literalStringValue.substring(1, literalStringValue.length() - 1);
        this.checkLiteralStringStartAndEndCharacter(previousLiteralStringValue, literalStringValue, previousMethodCallAST.getLineNo());
        if (this._hasIncorrectLineBreaks(methodCallAST) | this._hasIncorrectLineBreaks(previousMethodCallAST)) {
            return;
        }
        if (literalStringValue.startsWith("<") || literalStringValue.endsWith(">") || previousLiteralStringValue.startsWith("<") || previousLiteralStringValue.endsWith(">")) {
            return;
        }
        String previousLine = this.getLine(previousMethodCallAST.getLineNo() - 1);
        int previousLineLength = CommonUtil.lengthExpandedTabs((String)previousLine, (int)previousLine.length(), (int)this.getTabWidth());
        if (previousLineLength + literalStringValue.length() <= this.maxLineLength) {
            this.log(methodCallAST, "literal.string.combine", new Object[]{previousLiteralStringValue, literalStringValue});
        } else {
            int pos = this.getStringBreakPos(previousLiteralStringValue, literalStringValue, this.maxLineLength - previousLineLength);
            if (pos != -1) {
                this.log(methodCallAST, "literal.string.move", new Object[]{literalStringValue.substring(0, pos + 1)});
            }
        }
    }

    private void _checkPlusOperator(DetailAST parameterDetailAST) {
        if (parameterDetailAST.getType() != 125) {
            return;
        }
        List<DetailAST> literalStringASTList = DetailASTUtil.getAllChildTokens(parameterDetailAST, true, 139);
        if (!literalStringASTList.isEmpty()) {
            this.log(parameterDetailAST, _MSG_INCORRECT_PLUS, new Object[0]);
        }
    }

    private boolean _containsMethodCall(DetailAST detailAST, String variableName, String ... methodNames) {
        for (String methodName : methodNames) {
            List<DetailAST> methodCallASTList = DetailASTUtil.getMethodCalls(detailAST, variableName, methodName);
            if (methodCallASTList.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private DetailAST _getParameterDetailAST(DetailAST methodCallAST) {
        DetailAST elistAST = methodCallAST.findFirstToken(34);
        DetailAST exprAST = elistAST.findFirstToken(28);
        if (exprAST == null) {
            return null;
        }
        return exprAST.getFirstChild();
    }

    private boolean _hasIncorrectLineBreaks(DetailAST methodCallAST) {
        if (DetailASTUtil.getStartLine(methodCallAST) != DetailASTUtil.getEndLine(methodCallAST)) {
            this.log(methodCallAST, _MSG_INCORRECT_LINE_BREAK, new Object[0]);
            return true;
        }
        return false;
    }
}

