/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaBooleanStatementCheck
extends BaseJavaTermCheck {
    private static final Pattern _booleanPattern = Pattern.compile("\n(\t+)boolean (\\w+) =(.*?);\n", 32);
    private static final Pattern _relationalOperatorPattern = Pattern.compile(".* (==|!=|<|>|>=|<=)[ \n].*");

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        return this._formatBooleanStatements(javaTerm);
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR, JAVA_METHOD};
    }

    private String _formatBooleanStatement(String javaTermContent, String booleanStatement, String tabs, String variableName, String ifCondition, String trueValue, String falseValue) {
        StringBundler sb = new StringBundler(19);
        sb.append("\n\n");
        sb.append(tabs);
        sb.append("boolean ");
        sb.append(variableName);
        sb.append(" = ");
        sb.append(falseValue);
        sb.append(";\n\n");
        sb.append(tabs);
        sb.append("if (");
        sb.append(ifCondition);
        sb.append(") {\n\n");
        sb.append(tabs);
        sb.append("\t");
        sb.append(variableName);
        sb.append(" = ");
        sb.append(trueValue);
        sb.append(";\n");
        sb.append(tabs);
        sb.append("}\n");
        return StringUtil.replace(javaTermContent, booleanStatement, sb.toString());
    }

    private String _formatBooleanStatements(JavaTerm javaTerm) {
        String javaTermContent = javaTerm.getContent();
        Matcher matcher1 = _booleanPattern.matcher(javaTermContent);
        while (matcher1.find()) {
            String booleanStatement = matcher1.group();
            if (booleanStatement.contains("\t//") || booleanStatement.contains(" {\n")) continue;
            String criteria = matcher1.group(3);
            String[] ternaryOperatorParts = this.getTernaryOperatorParts(criteria);
            if (ternaryOperatorParts != null) {
                String falseValue = ternaryOperatorParts[2];
                String ifCondition = ternaryOperatorParts[0];
                String trueValue = ternaryOperatorParts[1];
                return this._formatBooleanStatement(javaTermContent, booleanStatement, matcher1.group(1), matcher1.group(2), ifCondition, trueValue, falseValue);
            }
            String strippedCriteria = this._stripQuotesAndMethodParameters(criteria);
            if (this.getLevel(strippedCriteria) == 0 && (strippedCriteria.contains("|") || strippedCriteria.contains("&") || strippedCriteria.contains("^"))) {
                return this._formatBooleanStatement(javaTermContent, booleanStatement, matcher1.group(1), matcher1.group(2), criteria, "true", "false");
            }
            Matcher matcher2 = _relationalOperatorPattern.matcher(strippedCriteria);
            if (!matcher2.find()) continue;
            return this._formatBooleanStatement(javaTermContent, booleanStatement, matcher1.group(1), matcher1.group(2), criteria, "true", "false");
        }
        return javaTermContent;
    }

    private String _stripQuotesAndMethodParameters(String s) {
        s = this.stripQuotes(s);
        block0: while (true) {
            int start = -1;
            for (int i = 1; i < s.length(); ++i) {
                String part;
                char c1 = s.charAt(i);
                if (start == -1) {
                    char c2;
                    if (c1 != '(' || !Character.isLetterOrDigit(c2 = s.charAt(i - 1))) continue;
                    start = i;
                    continue;
                }
                if (c1 != ')' || this.getLevel(part = s.substring(start, i + 1)) != 0) continue;
                s = StringUtil.replace(s, part, "", start);
                continue block0;
            }
            break;
        }
        return s;
    }
}

