/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSSPropertiesOrderCheck
extends BaseFileCheck {
    private static final Pattern _propertiesPattern = Pattern.compile("(^(\t*)[a-z]\\S*: .+;\n)+", 8);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._sortProperties(content);
    }

    private String _sortProperties(String content) {
        Matcher matcher = _propertiesPattern.matcher(content);
        while (matcher.find()) {
            String parameters = StringUtil.trimTrailing(matcher.group());
            String newParameters = StringUtil.removeChar(parameters, '\t');
            List<String> parameterList = ListUtil.fromArray(StringUtil.splitLines(newParameters));
            Collections.sort(parameterList, new PropertyComparator());
            String tabs = matcher.group(2);
            StringBundler sb = new StringBundler(parameterList.size() * 3);
            for (String parameter : parameterList) {
                sb.append(tabs);
                sb.append(parameter);
                sb.append("\n");
            }
            newParameters = sb.toString();
            newParameters = newParameters.substring(0, newParameters.length() - 1);
            content = StringUtil.replaceFirst(content, parameters, newParameters, matcher.start() - 1);
        }
        return content;
    }

    private class PropertyComparator
    extends NaturalOrderStringComparator {
        private PropertyComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            int pos1 = s1.indexOf(58);
            int pos2 = s2.indexOf(58);
            return super.compare(s1.substring(0, pos1), s2.substring(0, pos2));
        }
    }
}

