/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.source.formatter.ExcludeSyntaxPattern;
import com.liferay.source.formatter.SourceFormatter;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.checks.SinceJava;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.liferay.source.formatter.util.ThreadSafeSortedClassLibraryBuilder;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.library.ClassLibraryBuilder;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import com.thoughtworks.qdox.model.impl.DefaultJavaParameterizedType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class MissingOverrideCheck
extends BaseCheck {
    private static final double _LOWEST_SUPPORTED_JAVA_VERSION = 1.7;
    private static final String _MSG_MISSING_OVERRIDE = "override.missing";
    private JavaProjectBuilder _javaProjectBuilder;

    public int[] getDefaultTokens() {
        return new int[]{16};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        FileContents fileContents = this.getFileContents();
        String fileName = StringUtil.replace(fileContents.getFileName(), '\\', '/');
        JavaProjectBuilder javaProjectBuilder = null;
        try {
            javaProjectBuilder = this._getJavaProjectBuilder(fileName);
        }
        catch (Exception e) {
            return;
        }
        if (javaProjectBuilder == null) {
            return;
        }
        JavaClass javaClass = javaProjectBuilder.getClassByName(this._getPackageName(detailAST) + "." + this._getClassName(fileName));
        List<Tuple> ancestorJavaClassTuples = this._addAncestorJavaClassTuples(javaClass, javaProjectBuilder, new ArrayList<Tuple>());
        for (JavaMethod javaMethod : javaClass.getMethods()) {
            if (javaMethod.getLineNumber() == 0 || this._hasAnnotation(javaMethod, "Override") || !this._isOverrideMethod(javaClass, javaMethod, javaProjectBuilder, ancestorJavaClassTuples)) continue;
            this.log(javaMethod.getLineNumber(), _MSG_MISSING_OVERRIDE, new Object[0]);
        }
    }

    private List<Tuple> _addAncestorJavaClassTuples(JavaClass javaClass, JavaProjectBuilder javaProjectBuilder, List<Tuple> ancestorJavaClassTuples) {
        JavaClass superJavaClass = javaClass.getSuperJavaClass();
        if (superJavaClass != null) {
            ancestorJavaClassTuples.add(new Tuple(superJavaClass));
            ancestorJavaClassTuples = this._addAncestorJavaClassTuples(superJavaClass, javaProjectBuilder, ancestorJavaClassTuples);
        }
        for (JavaClass interfaceClass : javaClass.getInterfaces()) {
            if (!(interfaceClass instanceof DefaultJavaParameterizedType)) continue;
            DefaultJavaParameterizedType defaultJavaParameterizedType = (DefaultJavaParameterizedType)interfaceClass;
            List actualTypeArguments = defaultJavaParameterizedType.getActualTypeArguments();
            if (actualTypeArguments == null) {
                ancestorJavaClassTuples.add(new Tuple(interfaceClass));
            } else {
                ancestorJavaClassTuples.add(new Tuple(interfaceClass, actualTypeArguments));
            }
            ancestorJavaClassTuples = this._addAncestorJavaClassTuples(interfaceClass, javaProjectBuilder, ancestorJavaClassTuples);
        }
        return ancestorJavaClassTuples;
    }

    private String _getClassName(String fileName) {
        int pos = fileName.lastIndexOf(47);
        return fileName.substring(pos + 1, fileName.length() - 5);
    }

    private JavaProjectBuilder _getJavaProjectBuilder(String fileName) throws IOException {
        int x;
        File file;
        if (this._javaProjectBuilder != null) {
            return this._javaProjectBuilder;
        }
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder((ClassLibraryBuilder)new ThreadSafeSortedClassLibraryBuilder());
        String absolutePath = SourceUtil.getAbsolutePath(fileName);
        do {
            if ((x = absolutePath.lastIndexOf("/")) != -1) continue;
            return null;
        } while (!(file = new File((absolutePath = absolutePath.substring(0, x)) + "/portal-impl")).exists());
        Set<ExcludeSyntaxPattern> defaultExcludeSyntaxPatterns = SetUtil.fromArray(SourceFormatter.DEFAULT_EXCLUDE_SYNTAX_PATTERNS);
        List<String> fileNames = SourceFormatterUtil.scanForFiles(absolutePath + "/", new String[0], new String[]{"**/*.java"}, new SourceFormatterExcludes(defaultExcludeSyntaxPatterns), true);
        for (String curFileName : fileNames) {
            curFileName = StringUtil.replace(curFileName, '\\', '/');
            try {
                javaProjectBuilder.addSource(new File(SourceUtil.getAbsolutePath(curFileName)));
            }
            catch (Exception exception) {}
        }
        this._javaProjectBuilder = javaProjectBuilder;
        return this._javaProjectBuilder;
    }

    private String _getPackageName(DetailAST packageDefAST) {
        DetailAST dotAST = packageDefAST.findFirstToken(59);
        FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)dotAST);
        return fullIdent.getText();
    }

    private boolean _hasAnnotation(JavaMethod javaMethod, String annotationName) {
        List annotations = javaMethod.getAnnotations();
        if (annotations == null) {
            return false;
        }
        for (JavaAnnotation javaAnnotation : annotations) {
            JavaClass javaClass = javaAnnotation.getType();
            if (!annotationName.equals(javaClass.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean _isOverrideMethod(JavaClass javaClass, JavaMethod javaMethod, JavaProjectBuilder javaProjectBuilder, Collection<Tuple> ancestorJavaClassTuples) {
        if (javaMethod.isPrivate() || javaMethod.isStatic() || this._overridesHigherJavaAPIVersion(javaMethod)) {
            return false;
        }
        String methodName = javaMethod.getName();
        List parameterTypes = javaMethod.getParameterTypes();
        for (Tuple ancestorJavaClassTuple : ancestorJavaClassTuples) {
            JavaClass ancestorJavaClass = (JavaClass)ancestorJavaClassTuple.getObject(0);
            JavaMethod ancestorJavaMethod = null;
            String ancestorJavaClassName = ancestorJavaClass.getFullyQualifiedName();
            if (ancestorJavaClassTuple.getSize() == 1 || ancestorJavaClassName.equals("java.util.Map") && methodName.equals("get")) {
                ancestorJavaMethod = ancestorJavaClass.getMethodBySignature(methodName, parameterTypes);
            } else {
                List ancestorActualTypeArguments = (List)ancestorJavaClassTuple.getObject(1);
                ArrayList<Object> genericTypes = new ArrayList<Object>();
                for (JavaType parameterType : parameterTypes) {
                    String typeValue = parameterType.getValue();
                    boolean useGenericType = false;
                    for (JavaType ancestorActualTypeArgument : ancestorActualTypeArguments) {
                        if (!typeValue.equals(ancestorActualTypeArgument.getValue())) continue;
                        useGenericType = true;
                        break;
                    }
                    if (useGenericType) {
                        genericTypes.add(javaProjectBuilder.getClassByName("java.lang.Object"));
                        continue;
                    }
                    genericTypes.add(parameterType);
                }
                ancestorJavaMethod = ancestorJavaClass.getMethodBySignature(methodName, genericTypes);
            }
            if (ancestorJavaMethod == null) continue;
            boolean samePackage = false;
            JavaPackage ancestorJavaPackage = ancestorJavaClass.getPackage();
            if (ancestorJavaPackage != null) {
                samePackage = ancestorJavaPackage.equals(javaClass.getPackage());
            }
            if (samePackage) {
                return !ancestorJavaMethod.isPrivate();
            }
            return ancestorJavaMethod.isProtected() || ancestorJavaMethod.isPublic();
        }
        return false;
    }

    private boolean _overridesHigherJavaAPIVersion(JavaMethod javaMethod) {
        List annotations = javaMethod.getAnnotations();
        if (annotations == null) {
            return false;
        }
        for (JavaAnnotation annotation : annotations) {
            AnnotationValue annotationValue;
            double sinceJava;
            JavaClass javaClass = annotation.getType();
            String javaClassName = javaClass.getFullyQualifiedName();
            if (!javaClassName.equals(SinceJava.class.getName()) || !((sinceJava = GetterUtil.getDouble((annotationValue = annotation.getProperty("value")).getParameterValue())) > 1.7)) continue;
            return true;
        }
        return false;
    }
}

