/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaWhitespaceCheck
extends WhitespaceCheck {
    private final Pattern _forStatementPattern = Pattern.compile("\tfor \\(");
    private final Pattern _genericsPattern = Pattern.compile("\t<");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        content = this._formatWhitespace(fileName, content);
        content = this._formatForStatement(content);
        content = this._formatGenerics(content);
        content = StringUtil.replace(content, "\n\n\n", "\n\n");
        return content;
    }

    private String _fixMissingLeadingSpace(String content, String statement, String line) {
        String leadingWhitespace = this._getLeadingWhitespace(line);
        if (leadingWhitespace.contains(" ")) {
            return content;
        }
        String newLine = StringUtil.replaceFirst(line, leadingWhitespace, leadingWhitespace + " ");
        String newStatement = StringUtil.replaceFirst(statement, line, newLine);
        return StringUtil.replaceFirst(content, statement, newStatement);
    }

    private String _formatForStatement(String content) {
        Matcher matcher = this._forStatementPattern.matcher(content);
        while (matcher.find()) {
            String line;
            int x;
            String statement = this._getStatement(content, matcher.start(), "(", ")");
            if (statement == null || (x = statement.indexOf(";\n")) == -1) continue;
            int i = this.getLineNumber(statement, x) + 1;
            while ((line = this.getLine(statement, i)) != null) {
                String newContent = this._fixMissingLeadingSpace(content, statement, line);
                if (!newContent.equals(content)) {
                    return newContent;
                }
                ++i;
            }
        }
        return content;
    }

    private String _formatGenerics(String content) {
        Matcher matcher = this._genericsPattern.matcher(content);
        block0: while (matcher.find()) {
            String statement = this._getStatement(content, matcher.start(), "<", ">");
            if (statement == null) continue;
            int x = -1;
            while ((x = statement.indexOf(",\n", x + 1)) != -1) {
                String s = statement.substring(0, x);
                if (this.getLevel(s, "<", ">") != 1) continue;
                String line = this.getLine(statement, this.getLineNumber(statement, x) + 1);
                if (line == null) continue block0;
                String newContent = this._fixMissingLeadingSpace(content, statement, line);
                if (newContent.equals(content)) continue;
                return newContent;
            }
        }
        return content;
    }

    private String _formatWhitespace(String fileName, String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String previousLine = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                int previousLineLeadingTabCount;
                int lineLeadingTabCount;
                String trimmedLine = StringUtil.trimLeading(line = this.trimLine(fileName, line));
                if (trimmedLine.startsWith("*\t")) {
                    line = StringUtil.replaceFirst(line, "*\t", "* ");
                }
                if (trimmedLine.startsWith("//") || trimmedLine.startsWith("*")) {
                    sb.append(line);
                    sb.append("\n");
                    previousLine = line;
                    continue;
                }
                if (!(!line.contains("\t ") || previousLine.matches(".*[&|^]") || previousLine.contains("\t(") || previousLine.contains("\t<") || previousLine.contains("\t ") || previousLine.contains("\tfor (") || previousLine.contains("\timplements ") || previousLine.contains("\tthrows "))) {
                    line = StringUtil.replace(line, "\t ", "\t");
                }
                line = this.formatIncorrectSyntax(line, ",}", "}", false);
                line = this.formatWhitespace(line, trimmedLine, true);
                if (!trimmedLine.equals("{") && line.endsWith("{") && !line.endsWith(" {")) {
                    line = StringUtil.replaceLast(line, '{', " {");
                }
                if ((lineLeadingTabCount = this.getLeadingTabCount(line)) - 2 == (previousLineLeadingTabCount = this.getLeadingTabCount(previousLine)) && previousLineLeadingTabCount > 0 && line.endsWith(";") && !previousLine.contains("\tfor (") && !previousLine.contains("\ttry (")) {
                    line = StringUtil.replaceFirst(line, '\t', "");
                }
                sb.append(line);
                sb.append("\n");
                previousLine = line;
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    private String _getLeadingWhitespace(String s) {
        StringBundler sb = new StringBundler();
        for (char c : s.toCharArray()) {
            if (!Character.isWhitespace(c)) {
                return sb.toString();
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String _getStatement(String content, int start, String openChar, String closingChar) {
        String statement;
        int x = start;
        do {
            if ((x = content.indexOf(closingChar, x + 1)) != -1) continue;
            return null;
        } while (this.getLevel(statement = content.substring(start, x + 1), openChar, closingChar) != 0);
        return statement;
    }
}

