/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaTermStylingCheck
extends BaseJavaTermCheck {
    private final Pattern _lineBreakPattern = Pattern.compile("\n(.*)\\(\n((.+,\n)*.*\\)) \\+\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        Matcher matcher = this._lineBreakPattern.matcher(javaTerm.getContent());
        while (matcher.find()) {
            if (this.getLevel(matcher.group(2)) >= 0) continue;
            int pos = fileContent.indexOf(matcher.group()) + 1;
            int lineNumber = this.getLineNumber(fileContent, pos);
            this.addMessage(fileName, "Create a new var for '" + StringUtil.trim(matcher.group(1)) + "' for better readability", lineNumber);
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR, JAVA_METHOD};
    }
}

