/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@StatelessCheck
public class DesignForExtensionCheck
extends AbstractCheck {
    public static final String MSG_KEY = "design.forExtension";
    private Set<String> ignoredAnnotations = Arrays.stream(new String[]{"Test", "Before", "After", "BeforeClass", "AfterClass"}).collect(Collectors.toSet());

    public void setIgnoredAnnotations(String ... ignoredAnnotations) {
        this.ignoredAnnotations = Arrays.stream(ignoredAnnotations).collect(Collectors.toSet());
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{9};
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST classDef;
        if (!DesignForExtensionCheck.hasJavadocComment(ast) && DesignForExtensionCheck.canBeOverridden(ast) && (DesignForExtensionCheck.isNativeMethod(ast) || !DesignForExtensionCheck.hasEmptyImplementation(ast)) && !DesignForExtensionCheck.hasIgnoredAnnotation(ast, this.ignoredAnnotations) && DesignForExtensionCheck.canBeSubclassed(classDef = DesignForExtensionCheck.getNearestClassOrEnumDefinition(ast))) {
            String className = classDef.findFirstToken(58).getText();
            String methodName = ast.findFirstToken(58).getText();
            this.log(ast, MSG_KEY, className, methodName);
        }
    }

    private static boolean hasJavadocComment(DetailAST methodDef) {
        return DesignForExtensionCheck.hasJavadocCommentOnToken(methodDef, 5) || DesignForExtensionCheck.hasJavadocCommentOnToken(methodDef, 13);
    }

    private static boolean hasJavadocCommentOnToken(DetailAST methodDef, int tokenType) {
        DetailAST token = methodDef.findFirstToken(tokenType);
        return token.branchContains(145);
    }

    private static boolean isNativeMethod(DetailAST ast) {
        DetailAST mods = ast.findFirstToken(5);
        return mods.findFirstToken(66) != null;
    }

    private static boolean hasEmptyImplementation(DetailAST ast) {
        DetailAST methodImplCloseBrace;
        Predicate<DetailAST> predicate;
        boolean hasEmptyBody = true;
        DetailAST methodImplOpenBrace = ast.findFirstToken(7);
        Optional<DetailAST> methodBody = TokenUtil.findFirstTokenByPredicate(methodImplOpenBrace, predicate = arg_0 -> DesignForExtensionCheck.lambda$hasEmptyImplementation$0(methodImplCloseBrace = methodImplOpenBrace.getLastChild(), arg_0));
        if (methodBody.isPresent()) {
            hasEmptyBody = false;
        }
        return hasEmptyBody;
    }

    private static boolean canBeOverridden(DetailAST methodDef) {
        DetailAST modifiers = methodDef.findFirstToken(5);
        return ScopeUtil.getSurroundingScope(methodDef).isIn(Scope.PROTECTED) && !ScopeUtil.isInInterfaceOrAnnotationBlock(methodDef) && modifiers.findFirstToken(61) == null && modifiers.findFirstToken(40) == null && modifiers.findFirstToken(39) == null && modifiers.findFirstToken(64) == null;
    }

    private static boolean hasIgnoredAnnotation(DetailAST methodDef, Set<String> annotations) {
        Optional<DetailAST> annotation;
        DetailAST modifiers = methodDef.findFirstToken(5);
        boolean hasIgnoredAnnotation = false;
        if (modifiers.findFirstToken(159) != null && (annotation = TokenUtil.findFirstTokenByPredicate(modifiers, currentToken -> currentToken.getType() == 159 && annotations.contains(DesignForExtensionCheck.getAnnotationName(currentToken)))).isPresent()) {
            hasIgnoredAnnotation = true;
        }
        return hasIgnoredAnnotation;
    }

    private static String getAnnotationName(DetailAST annotation) {
        DetailAST dotAst = annotation.findFirstToken(59);
        String name = dotAst == null ? annotation.findFirstToken(58).getText() : dotAst.findFirstToken(58).getText();
        return name;
    }

    private static DetailAST getNearestClassOrEnumDefinition(DetailAST ast) {
        DetailAST searchAST = ast;
        while (searchAST.getType() != 14 && searchAST.getType() != 154) {
            searchAST = searchAST.getParent();
        }
        return searchAST;
    }

    private static boolean canBeSubclassed(DetailAST classDef) {
        DetailAST modifiers = classDef.findFirstToken(5);
        return classDef.getType() != 154 && modifiers.findFirstToken(39) == null && DesignForExtensionCheck.hasDefaultOrExplicitNonPrivateCtor(classDef);
    }

    private static boolean hasDefaultOrExplicitNonPrivateCtor(DetailAST classDef) {
        DetailAST objBlock = classDef.findFirstToken(6);
        boolean hasDefaultConstructor = true;
        boolean hasExplicitNonPrivateCtor = false;
        for (DetailAST candidate = objBlock.getFirstChild(); candidate != null; candidate = candidate.getNextSibling()) {
            if (candidate.getType() != 8) continue;
            hasDefaultConstructor = false;
            DetailAST ctorMods = candidate.findFirstToken(5);
            if (ctorMods.findFirstToken(61) != null) continue;
            hasExplicitNonPrivateCtor = true;
            break;
        }
        return hasDefaultConstructor || hasExplicitNonPrivateCtor;
    }

    private static /* synthetic */ boolean lambda$hasEmptyImplementation$0(DetailAST methodImplCloseBrace, DetailAST currentNode) {
        return currentNode != methodImplCloseBrace && !TokenUtil.isCommentType(currentNode.getType());
    }
}

