/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.TreeWalkerAuditEvent;
import com.puppycrawl.tools.checkstyle.TreeWalkerFilter;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.xpath.XpathQueryGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class XpathFileGeneratorAstFilter
extends AutomaticBean
implements TreeWalkerFilter {
    private static final String DELIMITER = " | \n";
    private static final List<TreeWalkerAuditEvent> EVENTS = new ArrayList<TreeWalkerAuditEvent>();
    private static final List<String> QUERIES = new ArrayList<String>();
    private int tabWidth;

    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    public static String findCorrespondingXpathQuery(AuditEvent event) {
        String result = null;
        for (int i = 0; i < EVENTS.size(); ++i) {
            TreeWalkerAuditEvent treeWalkerAuditEvent = EVENTS.get(i);
            if (!event.getSourceName().equals(treeWalkerAuditEvent.getSourceName()) || event.getLine() != treeWalkerAuditEvent.getLine() || event.getColumn() != treeWalkerAuditEvent.getColumn() || !event.getFileName().endsWith(treeWalkerAuditEvent.getFileName())) continue;
            result = QUERIES.get(i);
            break;
        }
        return result;
    }

    @Override
    protected void finishLocalSetup() {
        XpathFileGeneratorAstFilter.cleanup();
    }

    private static void cleanup() {
        QUERIES.clear();
        EVENTS.clear();
    }

    @Override
    public boolean accept(TreeWalkerAuditEvent event) {
        XpathQueryGenerator xpathQueryGenerator;
        List<String> xpathQueries;
        if (event.getTokenType() != 0 && !(xpathQueries = (xpathQueryGenerator = new XpathQueryGenerator(event, this.tabWidth)).generate()).isEmpty()) {
            String query = xpathQueries.stream().collect(Collectors.joining(DELIMITER));
            EVENTS.add(event);
            QUERIES.add(query);
        }
        return true;
    }
}

