/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class JavaTerm {
    public static final int TYPE_CLASS_PRIVATE = 24;
    public static final int TYPE_CLASS_PRIVATE_STATIC = 23;
    public static final int TYPE_CLASS_PROTECTED = 16;
    public static final int TYPE_CLASS_PROTECTED_STATIC = 15;
    public static final int TYPE_CLASS_PUBLIC = 8;
    public static final int TYPE_CLASS_PUBLIC_STATIC = 7;
    public static final int TYPE_CONSTRUCTOR_PRIVATE = 18;
    public static final int TYPE_CONSTRUCTOR_PROTECTED = 10;
    public static final int TYPE_CONSTRUCTOR_PUBLIC = 4;
    public static final int TYPE_METHOD_PRIVATE = 19;
    public static final int TYPE_METHOD_PRIVATE_STATIC = 17;
    public static final int TYPE_METHOD_PROTECTED = 11;
    public static final int TYPE_METHOD_PROTECTED_STATIC = 9;
    public static final int TYPE_METHOD_PUBLIC = 5;
    public static final int TYPE_METHOD_PUBLIC_STATIC = 3;
    public static final int TYPE_STATIC_BLOCK = 21;
    public static final int TYPE_VARIABLE_PRIVATE = 22;
    public static final int TYPE_VARIABLE_PRIVATE_STATIC = 20;
    public static final int TYPE_VARIABLE_PROTECTED = 14;
    public static final int TYPE_VARIABLE_PROTECTED_STATIC = 12;
    public static final int TYPE_VARIABLE_PUBLIC = 6;
    public static final int TYPE_VARIABLE_PUBLIC_STATIC = 1;
    private String _content;
    private String _indent;
    private int _lineCount;
    private String _name;
    private List<String> _parameterNames;
    private List<String> _parameterTypes;
    private int _type;

    public JavaTerm(String name, int type, String content, int lineCount, String indent) {
        this._name = name;
        this._type = type;
        this._content = content;
        this._lineCount = lineCount;
        this._indent = indent;
    }

    public String getContent() {
        return this._content;
    }

    public int getLineCount() {
        return this._lineCount;
    }

    public String getName() {
        return this._name;
    }

    public List<String> getParameterNames() {
        if (this._parameterNames == null) {
            this.readParameterNamesAndTypes();
        }
        return this._parameterNames;
    }

    public List<String> getParameterTypes() {
        if (this._parameterTypes == null) {
            this.readParameterNamesAndTypes();
        }
        return this._parameterTypes;
    }

    public int getType() {
        return this._type;
    }

    public boolean hasAnnotation(String annotation) {
        return this._content.contains(this._indent + "@" + annotation + "\n") || this._content.contains(this._indent + "@" + annotation + "(");
    }

    public boolean hasReturnType() {
        if (!this.isMethod()) {
            return false;
        }
        int i = this._content.indexOf(this._name);
        String methodSignature = StringUtil.trim(this._content.substring(0, i));
        return !methodSignature.endsWith(" void");
    }

    public boolean isClass() {
        return this._type == 24 || this._type == 23 || this._type == 16 || this._type == 15 || this._type == 8 || this._type == 7;
    }

    public boolean isConstructor() {
        return this._type == 18 || this._type == 10 || this._type == 4;
    }

    public boolean isMethod() {
        return this._type == 19 || this._type == 17 || this._type == 11 || this._type == 9 || this._type == 5 || this._type == 3;
    }

    public boolean isPrivate() {
        return this._type == 24 || this._type == 23 || this._type == 18 || this._type == 19 || this._type == 17 || this._type == 22 || this._type == 20;
    }

    public boolean isProtected() {
        return this._type == 16 || this._type == 15 || this._type == 10 || this._type == 11 || this._type == 9 || this._type == 14 || this._type == 12;
    }

    public boolean isPublic() {
        return this._type == 8 || this._type == 7 || this._type == 4 || this._type == 5 || this._type == 3 || this._type == 6 || this._type == 1;
    }

    public boolean isStatic() {
        return this._type == 23 || this._type == 15 || this._type == 7 || this._type == 17 || this._type == 9 || this._type == 3 || this._type == 20 || this._type == 12 || this._type == 1;
    }

    public boolean isVariable() {
        return this._type == 22 || this._type == 20 || this._type == 14 || this._type == 12 || this._type == 6 || this._type == 1;
    }

    public void setType(int type) {
        this._type = type;
    }

    protected void readParameterNamesAndTypes() {
        int openParenthesesCount;
        int closeParenthesesCount;
        this._parameterNames = new ArrayList<String>();
        this._parameterTypes = new ArrayList<String>();
        if (!this.isConstructor() && !this.isMethod()) {
            return;
        }
        int x = -1;
        if (this.isPrivate()) {
            x = this._content.indexOf("\tprivate ");
        } else if (this.isProtected()) {
            x = this._content.indexOf("\tprotected ");
        } else if (this.isPublic()) {
            x = this._content.indexOf("\tpublic ");
        }
        if (x == -1) {
            return;
        }
        int y = x = this._content.indexOf(40, x);
        String parameters = "";
        do {
            if ((y = this._content.indexOf(41, y + 1)) != -1) continue;
            return;
        } while ((closeParenthesesCount = StringUtil.count(parameters = this._content.substring(x + 1, y), ")")) != (openParenthesesCount = StringUtil.count(parameters, "(")));
        parameters = StringUtil.replace(parameters, new String[]{"\t", "\n"}, new String[]{"", " "});
        x = 0;
        while (true) {
            int lessThanCount;
            if ((parameters = StringUtil.trim(parameters)).startsWith("@")) {
                parameters = this.stripAnnotation(parameters);
            }
            if (parameters.startsWith("final ")) {
                parameters = parameters.substring(6);
            }
            if ((x = parameters.indexOf(32, x + 1)) == -1) {
                return;
            }
            String parameterType = parameters.substring(0, x);
            int greaterThanCount = StringUtil.count(parameterType, ">");
            if (greaterThanCount != (lessThanCount = StringUtil.count(parameterType, "<"))) continue;
            this._parameterTypes.add(parameterType);
            y = parameters.indexOf(44, x);
            if (y == -1) {
                this._parameterNames.add(parameters.substring(x + 1));
                return;
            }
            this._parameterNames.add(parameters.substring(x + 1, y));
            parameters = parameters.substring(y + 1);
            x = 0;
        }
    }

    protected String stripAnnotation(String parameters) {
        int lessThanCount;
        int greaterThanCount;
        String annotation;
        int openParenthesesCount;
        int closeParenthesesCount;
        int pos = -1;
        do {
            if ((pos = parameters.indexOf(32, pos + 1)) == -1) {
                return parameters;
            }
            annotation = parameters.substring(0, pos);
            closeParenthesesCount = StringUtil.count(annotation, ")");
            greaterThanCount = StringUtil.count(annotation, ">");
            lessThanCount = StringUtil.count(annotation, "<");
        } while (closeParenthesesCount != (openParenthesesCount = StringUtil.count(annotation, "(")) || greaterThanCount != lessThanCount);
        return parameters.substring(pos + 1);
    }
}

