/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.parser;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.JavaImportsFormatter;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaConstructor;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaStaticBlock;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;
import com.liferay.source.formatter.parser.ParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaClassParser {
    private static final Pattern _anonymousClassPattern = Pattern.compile("\n\t+(\\S.* )?new ((.|\\(\n|\\w\n)*\\)) \\{\n\n");
    private static final Pattern _implementsPattern = Pattern.compile("(\\A|\\s)implements\\s");

    public static List<JavaClass> parseAnonymousClasses(String content) throws IOException, ParseException {
        ArrayList<JavaClass> anonymousClasses = new ArrayList<JavaClass>();
        Matcher matcher = _anonymousClassPattern.matcher(content);
        while (matcher.find()) {
            String classContent;
            String s = content.substring(matcher.start(2), matcher.end());
            if (JavaSourceUtil.getLevel(s) != 0) continue;
            int x = matcher.start() + 1;
            int y = matcher.end();
            while (JavaSourceUtil.getLevel(classContent = content.substring(x, y), "{", "}") != 0) {
                ++y;
            }
            int lineNumber = SourceUtil.getLineNumber(content, matcher.start(2));
            anonymousClasses.add(JavaClassParser._parseJavaClass("", classContent, lineNumber, "private", false, false, false, true));
        }
        return anonymousClasses;
    }

    public static JavaClass parseJavaClass(String fileName, String content) throws IOException, ParseException {
        String[] importLines;
        String token;
        String className = JavaSourceUtil.getClassName(fileName);
        Pattern pattern = Pattern.compile(StringBundler.concat("\n(public\\s+)?(abstract\\s+)?(final\\s+)?@?", "(class|enum|interface)\\s+", className, "([<|\\s][^\\{]*)\\{"));
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            throw new ParseException("Parsing error");
        }
        int x = content.lastIndexOf("\n\n", matcher.start() + 1);
        int lineNumber = SourceUtil.getLineNumber(content, x + 2);
        String classContent = content.substring(x + 2);
        boolean isAbstract = false;
        if (matcher.group(2) != null) {
            isAbstract = true;
        }
        boolean isInterface = false;
        if (matcher.group(4) != null && (token = matcher.group(4)).equals("interface")) {
            isInterface = true;
        }
        JavaClass javaClass = JavaClassParser._parseJavaClass(className, classContent, lineNumber, "public", isAbstract, false, isInterface, false);
        javaClass.setPackageName(JavaSourceUtil.getPackageName(content));
        for (String importLine : importLines = StringUtil.splitLines(JavaImportsFormatter.getImports(content))) {
            if (!Validator.isNotNull(importLine)) continue;
            javaClass.addImport(importLine.substring(7, importLine.length() - 1));
        }
        return JavaClassParser._parseExtendsImplements(javaClass, StringUtil.trim(matcher.group(5)));
    }

    private static String _getClassName(String line) {
        int pos = line.indexOf(" extends ");
        if (pos == -1) {
            pos = line.indexOf(" implements ");
        }
        if (pos == -1) {
            pos = line.indexOf(123);
        }
        if (pos != -1) {
            line = line.substring(0, pos);
        }
        if ((pos = line.indexOf(60)) != -1) {
            line = line.substring(0, pos);
        }
        line = line.trim();
        pos = line.lastIndexOf(32);
        return line.substring(pos + 1);
    }

    private static String _getConstructorOrMethodName(String line, int pos) {
        line = line.substring(0, pos);
        int x = line.lastIndexOf(32);
        return line.substring(x + 1);
    }

    private static JavaTerm _getJavaTerm(String javaTermContent, String indent, int lineNumber) throws IOException, ParseException {
        Pattern pattern;
        Matcher matcher;
        String s = javaTermContent;
        if (javaTermContent.startsWith(indent + "/*")) {
            int pos = javaTermContent.indexOf("*/");
            s = javaTermContent.substring(pos);
        }
        if (!(matcher = (pattern = Pattern.compile("(\n|^)" + indent + "(private|protected|public|static)[ \n].*?[{;]\n", 32)).matcher(s)).find()) {
            return null;
        }
        s = s.substring(matcher.end(1), matcher.end() - 1);
        s = StringUtil.replace(s, new String[]{"\t", "(\n", "\n", " synchronized "}, new String[]{"", "(", " ", " "});
        for (String accessModifier : JavaTerm.ACCESS_MODIFIERS) {
            JavaTerm javaTerm = JavaClassParser._getJavaTerm(javaTermContent, s, accessModifier, lineNumber);
            if (javaTerm == null) continue;
            return javaTerm;
        }
        return null;
    }

    private static JavaTerm _getJavaTerm(String javaTermContent, String startLine, String accessModifier, int lineNumber) throws IOException, ParseException {
        if (startLine.startsWith("static {")) {
            return new JavaStaticBlock(javaTermContent, lineNumber);
        }
        if (!startLine.startsWith(accessModifier)) {
            return null;
        }
        boolean isAbstract = startLine.contains(" abstract ");
        boolean isInterface = startLine.contains(" interface ");
        boolean isStatic = startLine.contains(" static ");
        int x = startLine.indexOf(61);
        int y = startLine.indexOf(40);
        if (startLine.contains(" @interface ") || startLine.contains(" class ") || startLine.contains(" enum ") || startLine.contains(" interface ")) {
            return JavaClassParser._parseJavaClass(JavaClassParser._getClassName(startLine), javaTermContent, lineNumber, accessModifier, isAbstract, isStatic, isInterface, false);
        }
        if (x > 0 && (y == -1 || y > x) || startLine.endsWith(";") && y == -1) {
            return new JavaVariable(JavaClassParser._getVariableName(startLine), javaTermContent, accessModifier, lineNumber, isAbstract, isStatic);
        }
        if (y == -1) {
            return null;
        }
        int spaceCount = StringUtil.count(startLine.substring(0, y), ' ');
        if (isStatic || spaceCount > 1) {
            return new JavaMethod(JavaClassParser._getConstructorOrMethodName(startLine, y), javaTermContent, accessModifier, lineNumber, isAbstract, isStatic);
        }
        if (spaceCount == 1) {
            return new JavaConstructor(JavaClassParser._getConstructorOrMethodName(startLine, y), javaTermContent, accessModifier, lineNumber, isAbstract, isStatic);
        }
        return null;
    }

    private static int _getLineStartPos(String content, int lineNumber) {
        int x = 0;
        for (int i = 1; i < lineNumber; ++i) {
            if ((x = content.indexOf(10, x + 1)) != -1) continue;
            return x;
        }
        return x + 1;
    }

    private static String _getVariableName(String line) {
        int x = line.indexOf(61);
        int y = line.lastIndexOf(32);
        if (x != -1) {
            line = line.substring(0, x);
            line = StringUtil.trim(line);
            y = line.lastIndexOf(32);
            return line.substring(y + 1);
        }
        if (line.endsWith(";")) {
            return line.substring(y + 1, line.length() - 1);
        }
        return "";
    }

    private static JavaClass _parseExtendsImplements(JavaClass javaClass, String s) throws ParseException {
        int x;
        if (SourceUtil.getLevel(s, "<", ">") != 0) {
            throw new ParseException("Parsing error around class declaration");
        }
        while ((x = s.indexOf("<")) != -1) {
            int y = x;
            while (SourceUtil.getLevel(s.substring(x, (y = s.indexOf(">", y + 1)) + 1), "<", ">") != 0) {
            }
            s = StringUtil.trim(s.substring(0, x) + s.substring(y + 1));
        }
        Matcher matcher = _implementsPattern.matcher(s);
        if (matcher.find()) {
            javaClass.addImplementedClassNames(StringUtil.split(s.substring(matcher.end())));
            s = StringUtil.trim(s.substring(0, matcher.start()));
        }
        if (s.startsWith("extends")) {
            javaClass.addExtendedClassNames(StringUtil.split(s.substring(7)));
        }
        return javaClass;
    }

    private static JavaClass _parseJavaClass(String className, String classContent, int lineNumber, String accessModifier, boolean isAbstract, boolean isStatic, boolean isInterface, boolean anonymous) throws IOException, ParseException {
        JavaClass javaClass = new JavaClass(className, classContent, accessModifier, lineNumber, isAbstract, isStatic, isInterface, anonymous);
        String indent = SourceUtil.getIndent(classContent) + "\t";
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(classContent));
        String line = null;
        int javaTermStartPos = -1;
        int level = 0;
        int javaClassLineNumber = 0;
        int metadataAnnotationLevel = 0;
        int metadataBlockCommentLevel = 0;
        boolean insideJavaTerm = false;
        boolean insideMetadataAnnotation = false;
        boolean insideMetadataBlockComment = false;
        boolean multiLineComment = false;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            int javaTermLineNumber;
            ++javaClassLineNumber;
            if (!insideJavaTerm && line.startsWith(indent + "@")) {
                insideMetadataAnnotation = true;
                metadataAnnotationLevel = SourceUtil.getLevel(line);
            } else if (insideMetadataAnnotation) {
                if (metadataAnnotationLevel == 0 && Validator.isNotNull(line)) {
                    insideMetadataAnnotation = false;
                }
                metadataAnnotationLevel += SourceUtil.getLevel(line);
            }
            if (!insideJavaTerm && line.startsWith(indent + "/*")) {
                insideMetadataBlockComment = true;
                metadataBlockCommentLevel = SourceUtil.getLevel(line, "/*", "*/");
            } else if (insideMetadataBlockComment) {
                if (metadataBlockCommentLevel == 0 && Validator.isNotNull(line)) {
                    insideMetadataBlockComment = false;
                }
                metadataBlockCommentLevel += SourceUtil.getLevel(line, "/*", "*/");
            }
            if (!insideJavaTerm) {
                if (javaTermStartPos == -1) {
                    if (line.matches(indent + "\\S+.*")) {
                        javaTermStartPos = JavaClassParser._getLineStartPos(classContent, javaClassLineNumber);
                    }
                } else if (Validator.isNull(line) && !insideMetadataAnnotation && !insideMetadataBlockComment) {
                    javaTermStartPos = -1;
                }
            }
            if (line.matches("\\s*//.*")) continue;
            if (multiLineComment) {
                if (!line.matches(".*\\*/")) continue;
                multiLineComment = false;
                continue;
            }
            if (line.matches("\\s*/\\*.*")) {
                multiLineComment = true;
                continue;
            }
            level += SourceUtil.getLevel(line, "{", "}");
            if (line.matches(indent + "((private|protected|public)( .*|$)|static \\{)")) {
                insideJavaTerm = true;
                insideMetadataAnnotation = false;
                insideMetadataBlockComment = false;
            }
            if (!insideJavaTerm || !line.matches(".*[};]") || level != 1) continue;
            int nextLineStartPos = JavaClassParser._getLineStartPos(classContent, javaClassLineNumber + 1);
            String javaTermContent = classContent.substring(javaTermStartPos, nextLineStartPos);
            JavaTerm javaTerm = JavaClassParser._getJavaTerm(javaTermContent, indent, javaTermLineNumber = lineNumber - 1 + SourceUtil.getLineNumber(classContent, javaTermStartPos));
            if (javaTerm == null) {
                throw new ParseException("Parsing error at line '" + StringUtil.trim(line) + "'");
            }
            javaClass.addChildJavaTerm(javaTerm);
            insideJavaTerm = false;
            insideMetadataAnnotation = false;
            insideMetadataBlockComment = false;
            javaTermStartPos = nextLineStartPos;
        }
        return javaClass;
    }
}

