/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.util;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleSourceUtil {
    private static final Pattern _dependenciesPattern = Pattern.compile("(\n|\\A)(\t*)dependencies \\{\n");
    private static final Pattern _springBootPattern = Pattern.compile("\\s*springBoot\\s*\\{", 2);

    public static String getConfiguration(String dependency) {
        int pos = dependency.indexOf(" ");
        if (pos != -1) {
            return StringUtil.trim(dependency.substring(0, pos));
        }
        return StringUtil.trim(dependency);
    }

    public static List<String> getDependenciesBlocks(String content) {
        ArrayList<String> dependenciesBlocks = new ArrayList<String>();
        Matcher matcher = _dependenciesPattern.matcher(content);
        while (matcher.find()) {
            String dependencies;
            int level;
            int y = matcher.start();
            do {
                if ((y = content.indexOf("}", y + 1)) != -1) continue;
                return dependenciesBlocks;
            } while ((level = SourceUtil.getLevel(dependencies = content.substring(matcher.start(2), y + 1), "{", "}")) != 0);
            if (dependencies.contains("}\n")) continue;
            dependenciesBlocks.add(dependencies);
        }
        return dependenciesBlocks;
    }

    public static boolean isSpringBootExecutable(String content) {
        String s;
        Matcher matcher = _springBootPattern.matcher(content);
        if (!matcher.find()) {
            return false;
        }
        int x = matcher.start();
        do {
            if ((x = content.indexOf("}", x + 1)) != -1) continue;
            return false;
        } while (SourceUtil.getLevel(s = content.substring(matcher.start(), x + 1), "{", "}") != 0);
        return s.matches("(?is).*executable\\s*=\\s*true.*") && s.matches("(?is).*mainClass\\s*=.*");
    }
}

