/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class XMLResourceActionsFileCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws DocumentException {
        if (fileName.contains("/resource-actions/")) {
            this._checkResourceActionXML(fileName, content, "model");
            this._checkResourceActionXML(fileName, content, "portlet");
        }
        return content;
    }

    private void _checkResourceActionXML(String fileName, String content, String type) throws DocumentException {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        List resourceElements = rootElement.elements(type + "-resource");
        for (Element resourceElement : resourceElements) {
            Element nameElement = resourceElement.element(type + "-name");
            String name = "";
            if (nameElement != null) {
                name = nameElement.getText();
            }
            Element compositeModelNameElement = resourceElement.element("composite-model-name");
            this.checkElementOrder(fileName, compositeModelNameElement, "model-name", name, new ResourceActionNameElementComparator());
            Element portletRefElement = resourceElement.element("portlet-ref");
            this.checkElementOrder(fileName, portletRefElement, "portlet-name", name, new ResourceActionNameElementComparator());
            Element permissionsElement = resourceElement.element("permissions");
            if (permissionsElement == null) continue;
            List permissionsChildElements = permissionsElement.elements();
            for (Element permissionsChildElement : permissionsChildElements) {
                this.checkElementOrder(fileName, permissionsChildElement, "action-key", name, new ResourceActionNameElementComparator());
            }
        }
        this.checkElementOrder(fileName, rootElement, type + "-resource", null, new ResourceActionResourceElementComparator(type + "-name"));
    }

    private class ResourceActionResourceElementComparator
    extends ElementComparator {
        public ResourceActionResourceElementComparator(String nameAttribute) {
            super(nameAttribute);
        }

        @Override
        public String getElementName(Element portletResourceElement) {
            Element portletNameElement = portletResourceElement.element(this.getNameAttribute());
            if (portletNameElement == null) {
                return null;
            }
            return portletNameElement.getText();
        }
    }

    private class ResourceActionNameElementComparator
    extends ElementComparator {
        private ResourceActionNameElementComparator() {
        }

        @Override
        public String getElementName(Element actionNameElement) {
            return actionNameElement.getStringValue();
        }
    }
}

