/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class XMLPortletPreferencesFileCheck
extends BaseFileCheck {
    private final Pattern _incorrectDefaultPreferencesFileName = Pattern.compile("/default-([\\w-]+)-portlet-preferences\\.xml$");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws DocumentException {
        if (fileName.endsWith("portlet-preferences.xml")) {
            this._checkPortletPreferencesXML(fileName, content);
        }
        return content;
    }

    private void _checkPortletPreferencesXML(String fileName, String content) throws DocumentException {
        Document document = SourceUtil.readXML(content);
        this.checkElementOrder(fileName, document.getRootElement(), "preference", null, new PortletPreferenceElementComparator());
        Matcher matcher = this._incorrectDefaultPreferencesFileName.matcher(fileName);
        if (matcher.find()) {
            String correctFileName = matcher.group(1) + "-default-portlet-preferences.xml";
            this.addMessage(fileName, "Rename file to " + correctFileName);
        }
    }

    private class PortletPreferenceElementComparator
    extends ElementComparator {
        private PortletPreferenceElementComparator() {
        }

        @Override
        public String getElementName(Element preferenceElement) {
            Element nameElement = preferenceElement.element(this.getNameAttribute());
            return nameElement.getStringValue();
        }
    }
}

