/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UnusedVariableCheck
extends BaseCheck {
    private static final String _MSG_UNUSED_VARIABLE = "variable.unused";

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<DetailAST> variableDefASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 10);
        if (variableDefASTList.isEmpty()) {
            return;
        }
        List<String> tokenNames = this._getTokenNames(detailAST);
        for (DetailAST variableDefAST : variableDefASTList) {
            DetailAST nameAST;
            String variableName;
            DetailAST modifiersAST = variableDefAST.findFirstToken(5);
            if (modifiersAST.getChildCount() > 0 || Collections.frequency(tokenNames, variableName = (nameAST = variableDefAST.findFirstToken(58)).getText()) != 1) continue;
            this.log(variableDefAST.getLineNo(), _MSG_UNUSED_VARIABLE, new Object[]{variableName});
        }
    }

    private List<String> _getTokenNames(DetailAST detailAST) {
        ArrayList<String> tokenNames = new ArrayList<String>();
        List<DetailAST> nameASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 58);
        for (DetailAST nameAST : nameASTList) {
            tokenNames.add(nameAST.getText());
        }
        return tokenNames;
    }
}

