/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.xpath;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class XpathQueryGenerator {
    private final DetailAST rootAst;
    private final int lineNumber;
    private final int columnNumber;
    private final FileText fileText;
    private final int tabWidth;

    public XpathQueryGenerator(DetailAST rootAst, int lineNumber, int columnNumber, FileText fileText, int tabWidth) {
        this.rootAst = rootAst;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.fileText = fileText;
        this.tabWidth = tabWidth;
    }

    public List<String> generate() {
        return this.getMatchingAstElements().stream().map(XpathQueryGenerator::generateXpathQuery).collect(Collectors.toList());
    }

    private static DetailAST findChildWithIdent(DetailAST root) {
        return TokenUtils.findFirstTokenByPredicate(root, cur -> cur.findFirstToken(58) != null).orElse(null);
    }

    private static String generateXpathQuery(DetailAST ast) {
        DetailAST child;
        String xpathQuery = XpathQueryGenerator.getXpathQuery(null, ast);
        if (!XpathQueryGenerator.isUniqueAst(ast) && (child = XpathQueryGenerator.findChildWithIdent(ast)) != null) {
            xpathQuery = xpathQuery + "[." + XpathQueryGenerator.getXpathQuery(ast, child) + ']';
        }
        return xpathQuery;
    }

    private List<DetailAST> getMatchingAstElements() {
        ArrayList<DetailAST> result = new ArrayList<DetailAST>();
        DetailAST curNode = this.rootAst;
        while (curNode != null && curNode.getLineNo() <= this.lineNumber) {
            if (this.isMatchingByLineAndColumnAndNotIdent(curNode)) {
                result.add(curNode);
            }
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                toVisit = curNode.getNextSibling();
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
        return result;
    }

    private static String getXpathQuery(DetailAST root, DetailAST ast) {
        StringBuilder resultBuilder = new StringBuilder(1024);
        for (DetailAST cur = ast; cur != root; cur = cur.getParent()) {
            StringBuilder curNodeQueryBuilder = new StringBuilder(256);
            curNodeQueryBuilder.append('/').append(TokenUtils.getTokenName(cur.getType()));
            DetailAST identAst = cur.findFirstToken(58);
            if (identAst != null) {
                curNodeQueryBuilder.append("[@text='").append(identAst.getText()).append("']");
            }
            resultBuilder.insert(0, curNodeQueryBuilder);
        }
        return resultBuilder.toString();
    }

    private static boolean hasAtLeastOneSiblingWithSameTokenType(DetailAST ast) {
        boolean result = false;
        if (ast.getParent() == null) {
            for (DetailAST prev = ast.getPreviousSibling(); prev != null; prev = prev.getPreviousSibling()) {
                if (prev.getType() != ast.getType()) continue;
                result = true;
                break;
            }
            if (!result) {
                for (DetailAST next = ast.getNextSibling(); next != null; next = next.getNextSibling()) {
                    if (next.getType() != ast.getType()) continue;
                    result = true;
                    break;
                }
            }
        } else {
            result = ast.getParent().getChildCount(ast.getType()) > 1;
        }
        return result;
    }

    private int expandedTabColumn(DetailAST ast) {
        return 1 + CommonUtils.lengthExpandedTabs(this.fileText.get(this.lineNumber - 1), ast.getColumnNo(), this.tabWidth);
    }

    private boolean isMatchingByLineAndColumnAndNotIdent(DetailAST ast) {
        return ast.getType() != 58 && ast.getLineNo() == this.lineNumber && this.expandedTabColumn(ast) == this.columnNumber;
    }

    private static boolean isUniqueAst(DetailAST ast) {
        return ast.findFirstToken(58) != null || !XpathQueryGenerator.hasAtLeastOneSiblingWithSameTokenType(ast);
    }
}

