/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.GitUtil;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.checkstyle.util.AlloyMVCCheckstyleLogger;
import com.liferay.source.formatter.checkstyle.util.AlloyMVCCheckstyleUtil;
import com.liferay.source.formatter.checkstyle.util.CheckstyleUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class JSPSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.jsp", "**/*.jspf", "**/*.tag", "**/*.tpl", "**/*.vm"};
    private AlloyMVCCheckstyleLogger _checkstyleLogger;
    private Configuration _configuration;
    private final Set<SourceFormatterMessage> _sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
    private final List<File> _ungeneratedFiles = new ArrayList<File>();

    @Override
    protected List<String> doGetFileNames() throws Exception {
        String[] excludes = new String[]{"**/null.jsp", "**/tools/**"};
        List<String> fileNames = this.getFileNames(excludes, this.getIncludes());
        if (fileNames.isEmpty() || !this.sourceFormatterArgs.isFormatCurrentBranch() && !this.sourceFormatterArgs.isFormatLatestAuthor() && !this.sourceFormatterArgs.isFormatLocalChanges()) {
            return fileNames;
        }
        List<String> allJSPFileNames = this.getFileNames(excludes, this.getIncludes(), true);
        Map<String, String> contentsMap = JSPSourceUtil.getContentsMap(allJSPFileNames);
        Map<String, String> deletedContentsMap = this._getDeletedContentsMap(excludes);
        if (deletedContentsMap.isEmpty()) {
            return JSPSourceUtil.addIncludedAndReferencedFileNames(fileNames, new HashSet<String>(), contentsMap, false);
        }
        contentsMap.putAll(deletedContentsMap);
        fileNames.addAll(deletedContentsMap.keySet());
        fileNames = JSPSourceUtil.addIncludedAndReferencedFileNames(fileNames, new HashSet<String>(), contentsMap, true);
        fileNames.removeAll(deletedContentsMap.keySet());
        return fileNames;
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected File format(File file, String fileName, String absolutePath, String content) throws Exception {
        List<String> fileNames;
        if ((this.sourceFormatterArgs.isFormatCurrentBranch() || this.sourceFormatterArgs.isFormatLatestAuthor() || this.sourceFormatterArgs.isFormatLocalChanges()) && (fileNames = SourceFormatterUtil.filterFileNames(Arrays.asList(fileName), new String[0], new String[]{"*.*"}, this.getSourceFormatterExcludes(), false)).isEmpty()) {
            return file;
        }
        file = super.format(file, fileName, absolutePath, content);
        this._processCheckstyle(absolutePath, content);
        return file;
    }

    @Override
    protected void postFormat() throws Exception {
        this._processCheckstyle();
        for (SourceFormatterMessage sourceFormatterMessage : this._sourceFormatterMessages) {
            String fileName = sourceFormatterMessage.getFileName();
            this.processMessage(fileName, sourceFormatterMessage);
            this.printError(fileName, sourceFormatterMessage.toString());
        }
    }

    private Map<String, String> _getDeletedContentsMap(String[] excludes) throws Exception {
        List<Object> fileNames = Collections.emptyList();
        if (this.sourceFormatterArgs.isFormatCurrentBranch()) {
            fileNames = GitUtil.getCurrentBranchFileNames(this.sourceFormatterArgs.getBaseDirName(), this.sourceFormatterArgs.getGitWorkingBranchName(), true);
        } else if (this.sourceFormatterArgs.isFormatLatestAuthor()) {
            fileNames = GitUtil.getLatestAuthorFileNames(this.sourceFormatterArgs.getBaseDirName(), true);
        } else if (this.sourceFormatterArgs.isFormatLocalChanges()) {
            fileNames = GitUtil.getLocalChangesFileNames(this.sourceFormatterArgs.getBaseDirName(), true);
        }
        if (fileNames.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<String> deletedFileNames = new ArrayList<String>();
        for (String string : fileNames) {
            String absolutePath = SourceUtil.getAbsolutePath(string);
            File file = new File(absolutePath);
            if (Files.exists(file.toPath(), new LinkOption[0])) continue;
            deletedFileNames.add(string);
        }
        if (deletedFileNames.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> contentsMap = new HashMap<String, String>();
        List<String> list = SourceFormatterUtil.filterFileNames(deletedFileNames, excludes, this.getIncludes(), this.getSourceFormatterExcludes(), true);
        for (String filteredFileName : list) {
            String content = GitUtil.getCurrentBranchFileContent(this.sourceFormatterArgs.getGitWorkingBranchName(), filteredFileName);
            String fileName = StringUtil.replace(this.sourceFormatterArgs.getBaseDirName() + filteredFileName, '\\', '/');
            contentsMap.put(fileName, content);
        }
        return contentsMap;
    }

    private void _processCheckstyle() throws Exception {
        if (this._ungeneratedFiles.isEmpty()) {
            return;
        }
        if (this._configuration == null) {
            this._checkstyleLogger = new AlloyMVCCheckstyleLogger(new UnsyncByteArrayOutputStream(), true, this.sourceFormatterArgs.getBaseDirName());
            this._configuration = CheckstyleUtil.getConfiguration("checkstyle-alloy-mvc.xml", this.getPropertiesMap(), this.sourceFormatterArgs);
        }
        this._sourceFormatterMessages.addAll(this.processCheckstyle(this._configuration, this._checkstyleLogger, this._ungeneratedFiles.toArray(new File[this._ungeneratedFiles.size()])));
        for (File ungeneratedFile : this._ungeneratedFiles) {
            Files.deleteIfExists(ungeneratedFile.toPath());
        }
        this._ungeneratedFiles.clear();
    }

    private synchronized void _processCheckstyle(String absolutePath, String content) throws Exception {
        File file = AlloyMVCCheckstyleUtil.getJavaFile(absolutePath, content);
        if (file != null) {
            this._ungeneratedFiles.add(file);
            if (this._ungeneratedFiles.size() == 1000) {
                this._processCheckstyle();
            }
        }
    }
}

