/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.util;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class AlloyMVCCheckstyleUtil {
    private static final String _SRC_DIR = "src/main/resources/alloy_mvc/jsp/";
    private static final String _TMP_DIR = "tmp/main/resources/alloy_mvc/jsp/";

    public static File getJavaFile(String absolutePath, String content) throws IOException {
        if (!absolutePath.contains(_SRC_DIR)) {
            return null;
        }
        if (!absolutePath.endsWith(".jspf")) {
            return null;
        }
        if (!content.matches("(?s)<%--.*--%>(\\s*<%@[^\\n]*)*\\s*<%!\\s.*")) {
            return null;
        }
        if (StringUtil.count(content, "<%!") != 1) {
            return null;
        }
        if (!content.endsWith("\n%>")) {
            return null;
        }
        String s = absolutePath.replace(_SRC_DIR, _TMP_DIR);
        File javaFile = new File(s.substring(0, s.lastIndexOf(".")) + ".java");
        String javaContent = StringUtil.replace(content, new String[]{"<%--", "--%>", "<%@", "<%!"}, new String[]{"//<%--", "//--%>", "//<%@", "//<%!"});
        javaContent = StringUtil.replaceLast(javaContent, "\n%>", "");
        FileUtil.write(javaFile, javaContent);
        return javaFile;
    }

    public static String getSourceFileName(String fileName) {
        if (!fileName.contains(_TMP_DIR)) {
            return fileName;
        }
        String s = fileName.replace(_TMP_DIR, _SRC_DIR);
        return s.substring(0, s.lastIndexOf(".")) + ".jspf";
    }
}

