/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableNameCheck
extends BaseCheck {
    private static final String[][] _ALL_CAPS_STRINGS = new String[][]{{"DDL", "Ddl"}, {"DDM", "Ddm"}, {"DL", "Dl"}, {"PK", "Pk"}};
    private static final String _MSG_RENAME_VARIABLE = "variable.rename";
    private static final String _MSG_TYPO_VARIABLE = "variable.typo";
    private static final Pattern _isVariableNamePattern = Pattern.compile("(_?)(is|IS_)([A-Z])(.*)");

    public int[] getDefaultTokens() {
        return new int[]{21, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST modifiersAST = detailAST.findFirstToken(5);
        if (modifiersAST.branchContains(63) || modifiersAST.branchContains(62)) {
            return;
        }
        DetailAST nameAST = detailAST.findFirstToken(58);
        String name = nameAST.getText();
        this._checkCaps(detailAST, name);
        this._checkIsVariableName(detailAST, name);
        this._checkTypo(detailAST, name);
    }

    private void _checkCaps(DetailAST detailAST, String name) {
        for (String[] array : _ALL_CAPS_STRINGS) {
            Pattern pattern = Pattern.compile("(.*)" + array[1] + "([A-Z].*|$)");
            Matcher matcher = pattern.matcher(name);
            if (!matcher.find()) continue;
            String newName = matcher.group(1) + array[0] + matcher.group(2);
            this.log(detailAST.getLineNo(), _MSG_RENAME_VARIABLE, new Object[]{name, newName});
        }
    }

    private void _checkIsVariableName(DetailAST detailAST, String name) {
        if (!this._isBooleanType(detailAST.findFirstToken(13))) {
            return;
        }
        Matcher matcher = _isVariableNamePattern.matcher(name);
        if (!matcher.find()) {
            return;
        }
        String group2 = matcher.group(2);
        String newName = null;
        if (group2.equals("is")) {
            newName = StringUtil.toLowerCase(matcher.group(3)) + matcher.group(4);
            if (!Validator.isVariableName(newName)) {
                return;
            }
            newName = matcher.group(1) + newName;
        } else {
            newName = matcher.group(1) + matcher.group(3) + matcher.group(4);
        }
        if (!this._classHasVariableWithName(detailAST, newName)) {
            this.log(detailAST.getLineNo(), _MSG_RENAME_VARIABLE, new Object[]{name, newName});
        }
    }

    private void _checkTypo(DetailAST detailAST, String name) {
        String typeNameTrailingDigits;
        String trimmedTypeName;
        String expectedName;
        if (StringUtil.isUpperCase(name)) {
            return;
        }
        DetailAST typeAST = detailAST.findFirstToken(13);
        DetailAST firstChildAST = typeAST.getFirstChild();
        if (firstChildAST == null || firstChildAST.getType() != 58) {
            return;
        }
        String typeName = firstChildAST.getText();
        if (typeName.contains("_")) {
            return;
        }
        String nameTrailingDigits = this._getTrailingDigits(name);
        String trimmedName = StringUtil.replaceLast(name, nameTrailingDigits, "");
        String leadingUnderline = "";
        if (name.startsWith("_")) {
            leadingUnderline = "_";
            trimmedName = trimmedName.substring(1);
        }
        if (StringUtil.equals(trimmedName, expectedName = this._getExpectedVariableName(trimmedTypeName = StringUtil.replaceLast(typeName, typeNameTrailingDigits = this._getTrailingDigits(typeName), "")))) {
            return;
        }
        if (StringUtil.equalsIgnoreCase(trimmedName, trimmedTypeName)) {
            for (int i = expectedName.length() - 1; i >= 0; --i) {
                char c1 = trimmedName.charAt(i);
                if (c1 == expectedName.charAt(i) || i >= expectedName.length() - 1) continue;
                char c2 = trimmedName.charAt(i + 1);
                if (!Character.isUpperCase(c1) || !Character.isDigit(c2) && !Character.isUpperCase(c2)) continue;
                return;
            }
            this.log(detailAST.getLineNo(), _MSG_TYPO_VARIABLE, new Object[]{name, StringBundler.concat(leadingUnderline, expectedName, nameTrailingDigits)});
            return;
        }
        trimmedName = StringUtil.toLowerCase(trimmedName);
        trimmedTypeName = StringUtil.toLowerCase(trimmedTypeName);
        if (trimmedName.charAt(0) != trimmedTypeName.charAt(0) || trimmedName.charAt(trimmedName.length() - 1) != trimmedTypeName.charAt(trimmedTypeName.length() - 1)) {
            return;
        }
        int min = Math.min(trimmedName.length(), trimmedTypeName.length());
        int diff = Math.abs(trimmedName.length() - trimmedTypeName.length());
        if (min < 5 || diff > 1) {
            return;
        }
        int i = StringUtil.startsWithWeight(trimmedName, trimmedTypeName);
        if ((trimmedName = trimmedName.substring(i)).startsWith("_")) {
            return;
        }
        trimmedTypeName = trimmedTypeName.substring(i);
        for (int j = 1; j <= trimmedName.length() && j <= trimmedTypeName.length(); ++j) {
            if (trimmedName.charAt(trimmedName.length() - j) == trimmedTypeName.charAt(trimmedTypeName.length() - j)) continue;
            if (this._containSameCharacters(trimmedName, trimmedTypeName)) break;
            return;
        }
        this.log(detailAST.getLineNo(), _MSG_TYPO_VARIABLE, new Object[]{name, this._getExpectedVariableName(typeName, leadingUnderline, nameTrailingDigits)});
    }

    private boolean _classHasVariableWithName(DetailAST detailAST, String variableName) {
        ArrayList<DetailAST> definitionASTList = new ArrayList<DetailAST>();
        for (DetailAST parentAST = detailAST.getParent(); parentAST != null; parentAST = parentAST.getParent()) {
            if (parentAST.getType() == 9) {
                definitionASTList.addAll(DetailASTUtil.getAllChildTokens(parentAST, true, 21, 10));
            }
            if (parentAST.getType() != 14) continue;
            DetailAST objblockAST = parentAST.findFirstToken(6);
            definitionASTList.addAll(DetailASTUtil.getAllChildTokens(objblockAST, false, 10));
        }
        for (DetailAST definitionAST : definitionASTList) {
            DetailAST definitionNameAST = definitionAST.findFirstToken(58);
            if (!variableName.equals(definitionNameAST.getText())) continue;
            return true;
        }
        return false;
    }

    private boolean _containSameCharacters(String s1, String s2) {
        char[] chars1 = s1.toCharArray();
        char[] chars2 = s2.toCharArray();
        Arrays.sort(chars1);
        Arrays.sort(chars2);
        return Arrays.equals(chars1, chars2);
    }

    private String _getExpectedVariableName(String typeName) {
        if (StringUtil.isUpperCase(typeName)) {
            return StringUtil.toLowerCase(typeName);
        }
        if (typeName.startsWith("IDf")) {
            return StringUtil.replaceFirst(typeName, "IDf", "idf");
        }
        if (typeName.startsWith("OSGi")) {
            return StringUtil.replaceFirst(typeName, "OSGi", "osgi");
        }
        for (int i = 0; i < typeName.length(); ++i) {
            char c = typeName.charAt(i);
            if (!Character.isLowerCase(c)) continue;
            if (i == 0) {
                return typeName;
            }
            if (i == 1) {
                return StringUtil.toLowerCase(typeName.substring(0, 1)) + typeName.substring(1);
            }
            return StringUtil.toLowerCase(typeName.substring(0, i - 1)) + typeName.substring(i - 1);
        }
        return StringUtil.toLowerCase(typeName);
    }

    private String _getExpectedVariableName(String typeName, String leadingUnderline, String trailingDigits) {
        return StringBundler.concat(leadingUnderline, this._getExpectedVariableName(typeName), trailingDigits);
    }

    private String _getTrailingDigits(String s) {
        String digits = "";
        for (int i = s.length() - 1; i >= 0; --i) {
            if (!Character.isDigit(s.charAt(i))) {
                return digits;
            }
            digits = s.charAt(i) + digits;
        }
        return digits;
    }

    private boolean _isBooleanType(DetailAST typeAST) {
        String name;
        DetailAST childAST = typeAST.getFirstChild();
        if (childAST == null) {
            return false;
        }
        if (childAST.getType() == 50) {
            return true;
        }
        return childAST.getType() == 58 && (name = childAST.getText()).equals("Boolean");
    }
}

