/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.FileUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PersistenceCallCheck
extends BaseCheck {
    private static final String _MSG_ILLEGAL_PERSISTENCE_CALL = "persistence.call.illegal";
    private final Pattern _extendedClassPattern = Pattern.compile("\\sextends\\s+(\\w+)\\W");

    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parent = detailAST.getParent();
        if (parent != null) {
            return;
        }
        FileContents fileContents = this.getFileContents();
        String fileName = StringUtil.replace(fileContents.getFileName(), '\\', '/');
        if (!fileName.contains("/modules/")) {
            return;
        }
        FileText fileText = fileContents.getText();
        String content = (String)fileText.getFullText();
        JavaClass javaClass = null;
        try {
            javaClass = JavaClassParser.parseJavaClass(fileName, content);
        }
        catch (Exception e) {
            return;
        }
        Map<String, String> variablesMap = this._getVariablesMap(javaClass);
        variablesMap.putAll(this._getVariablesMap(this._getExtendedJavaClass(fileName, content)));
        List<DetailAST> methodCallASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallAST : methodCallASTList) {
            this._checkMethodCall(methodCallAST, javaClass.getImports(), variablesMap, javaClass.getPackageName());
        }
    }

    private void _checkClass(String className, List<String> importNames, String packageName, int lineNo) {
        for (String importName : importNames) {
            if (!importName.endsWith("." + className)) continue;
            int pos = importName.indexOf(".service.persistence.");
            if (pos == -1) {
                return;
            }
            if (packageName.startsWith(importName.substring(0, pos))) continue;
            this.log(lineNo, _MSG_ILLEGAL_PERSISTENCE_CALL, new Object[]{importName});
        }
    }

    private void _checkMethodCall(DetailAST methodCallAST, List<String> importNames, Map<String, String> variablesMap, String packageName) {
        String methodName;
        DetailAST childAST = methodCallAST.getFirstChild();
        if (childAST.getType() != 59) {
            return;
        }
        if ((childAST = childAST.getFirstChild()).getType() != 58) {
            return;
        }
        DetailAST siblingAST = childAST.getNextSibling();
        if (siblingAST.getType() == 58 && ((methodName = siblingAST.getText()).equals("clearCache") || methodName.startsWith("create"))) {
            return;
        }
        String fieldName = childAST.getText();
        if (fieldName.matches("[A-Z].*")) {
            this._checkClass(fieldName, importNames, packageName, methodCallAST.getLineNo());
        } else {
            this._checkVariable(fieldName, variablesMap, packageName, methodCallAST.getLineNo());
        }
    }

    private void _checkVariable(String variableName, Map<String, String> variablesMap, String packageName, int lineNo) {
        String fullyQualifiedTypeName = variablesMap.get(variableName);
        if (fullyQualifiedTypeName == null) {
            return;
        }
        int pos = fullyQualifiedTypeName.indexOf(".service.persistence.");
        if (pos == -1) {
            return;
        }
        if (!packageName.startsWith(fullyQualifiedTypeName.substring(0, pos))) {
            this.log(lineNo, _MSG_ILLEGAL_PERSISTENCE_CALL, new Object[]{fullyQualifiedTypeName});
        }
    }

    private JavaClass _getExtendedJavaClass(String fileName, String content) {
        Matcher matcher = this._extendedClassPattern.matcher(content);
        if (!matcher.find()) {
            return null;
        }
        String extendedClassName = matcher.group(1);
        Pattern pattern = Pattern.compile("\nimport (.*\\." + extendedClassName + ");");
        matcher = pattern.matcher(content);
        if (matcher.find() && !(extendedClassName = matcher.group(1)).startsWith("com.liferay.")) {
            return null;
        }
        if (!extendedClassName.contains(".")) {
            extendedClassName = JavaSourceUtil.getPackageName(content) + "." + extendedClassName;
        }
        int pos = fileName.lastIndexOf("/com/liferay/");
        String extendedClassFileName = fileName.substring(0, pos + 1) + StringUtil.replace(extendedClassName, '.', '/') + ".java";
        try {
            return JavaClassParser.parseJavaClass(extendedClassFileName, FileUtil.read(new File(extendedClassFileName)));
        }
        catch (Exception e) {
            return null;
        }
    }

    private String _getFullyQualifiedName(String className, JavaClass javaClass) {
        for (String importName : javaClass.getImports()) {
            if (!importName.endsWith("." + className)) continue;
            return importName;
        }
        return javaClass.getPackageName() + "." + className;
    }

    private Map<String, String> _getVariablesMap(JavaClass javaClass) {
        HashMap<String, String> variablesMap = new HashMap<String, String>();
        if (javaClass == null) {
            return variablesMap;
        }
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            Pattern pattern;
            Matcher matcher;
            if (!javaTerm.isJavaVariable() || !(matcher = (pattern = Pattern.compile("\\s(\\S+)\\s+(\\S+\\.)?" + javaTerm.getName())).matcher(javaTerm.getContent())).find()) continue;
            String fieldTypeClassName = matcher.group(1);
            if (!fieldTypeClassName.contains(".")) {
                fieldTypeClassName = this._getFullyQualifiedName(fieldTypeClassName, javaClass);
            }
            variablesMap.put(javaTerm.getName(), fieldTypeClassName);
        }
        return variablesMap;
    }
}

