/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class GetterMethodCallCheck
extends BaseCheck {
    private static final String _MSG_RENAME_METHOD_CALL = "method.call.rename";
    private String _baseDirName;
    private final Pattern _getterMethodNamePattern = Pattern.compile("^get([A-Z].*)");
    private String _portalBranchName;
    private final Map<String, Document> _serviceXMLDocumentsMap = new HashMap<String, Document>();

    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15};
    }

    public void setBaseDirName(String baseDirName) {
        this._baseDirName = baseDirName;
    }

    public void setPortalBranchName(String portalBranchName) {
        this._portalBranchName = portalBranchName;
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        if (parentAST != null) {
            return;
        }
        Map<DetailAST, String> getterMethodCallMap = this._getGetterMethodCallMap(detailAST);
        if (getterMethodCallMap.isEmpty()) {
            return;
        }
        List<String> importNames = this._getImportNames(detailAST);
        for (Map.Entry<DetailAST, String> entry : getterMethodCallMap.entrySet()) {
            DetailAST variableNameAST = entry.getKey();
            String variableName = variableNameAST.getText();
            String variableTypeName = DetailASTUtil.getVariableTypeName(variableNameAST, variableName, true);
            this._checkGetterCall(entry.getValue(), variableName, variableTypeName, importNames, variableNameAST.getLineNo());
        }
    }

    private void _checkGetterCall(String getterObjectName, String variableName, String variableTypeName, List<String> importNames, int lineNo) {
        if (!Validator.isVariableName(variableTypeName)) {
            return;
        }
        Document serviceXMLDocument = this._getServiceXMLDocument(this._getPackageName(variableTypeName, importNames));
        if (serviceXMLDocument == null || !serviceXMLDocument.hasContent()) {
            return;
        }
        Element rootElement = serviceXMLDocument.getRootElement();
        for (Element entityElement : rootElement.elements("entity")) {
            if (!variableTypeName.equals(entityElement.attributeValue("name"))) continue;
            for (Element columnElement : entityElement.elements("column")) {
                if (!getterObjectName.equals(columnElement.attributeValue("name")) || !Objects.equals(columnElement.attributeValue("type"), "boolean")) continue;
                String s = TextFormatter.format(getterObjectName, 6);
                this.log(lineNo, _MSG_RENAME_METHOD_CALL, new Object[]{StringBundler.concat(variableName, ".is", s, "()"), StringBundler.concat(variableName, ".get" + s, "()")});
            }
        }
    }

    private Map<DetailAST, String> _getGetterMethodCallMap(DetailAST detailAST) {
        HashMap<DetailAST, String> getterMethodCallMap = new HashMap<DetailAST, String>();
        List<DetailAST> methodCallASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallAST : methodCallASTList) {
            DetailAST methodNameAST;
            Matcher matcher;
            List<DetailAST> nameASTList;
            DetailAST elistAST;
            DetailAST dotAST = methodCallAST.findFirstToken(59);
            if (dotAST == null || (elistAST = methodCallAST.findFirstToken(34)).getChildCount() > 0 || (nameASTList = DetailASTUtil.getAllChildTokens(dotAST, false, 58)).size() != 2 || !(matcher = this._getterMethodNamePattern.matcher((methodNameAST = nameASTList.get(1)).getText())).find()) continue;
            String getterObjectName = TextFormatter.format(matcher.group(1), 8);
            getterMethodCallMap.put(nameASTList.get(0), getterObjectName);
        }
        return getterMethodCallMap;
    }

    private List<String> _getImportNames(DetailAST detailAST) {
        ArrayList<String> importASTList = new ArrayList<String>();
        DetailAST sibling = detailAST.getPreviousSibling();
        while (sibling.getType() == 30) {
            FullIdent importIdent = FullIdent.createFullIdentBelow((DetailAST)sibling);
            importASTList.add(importIdent.getText());
            sibling = sibling.getPreviousSibling();
        }
        return importASTList;
    }

    private String _getPackageName(String variableTypeName, List<String> importNames) {
        for (String importName : importNames) {
            if (!importName.endsWith(".kernel.model." + variableTypeName)) continue;
            return StringUtil.replaceLast(importName, "." + variableTypeName, "");
        }
        return "";
    }

    private Document _getServiceXMLDocument(String packageName) {
        if (Validator.isNull(packageName)) {
            return null;
        }
        if (this._serviceXMLDocumentsMap.containsKey(packageName)) {
            return this._serviceXMLDocumentsMap.get(packageName);
        }
        String fileLocation = StringBundler.concat("portal-impl/src/", packageName.replace('.', '/'), "/service.xml");
        fileLocation = StringUtil.replace(fileLocation, "/kernel/model", "");
        try {
            Document serviceXMLDocument = SourceUtil.readXML(SourceFormatterUtil.getPortalContent(this._baseDirName, this._portalBranchName, fileLocation));
            this._serviceXMLDocumentsMap.put(packageName, serviceXMLDocument);
            return serviceXMLDocument;
        }
        catch (Exception e) {
            this._serviceXMLDocumentsMap.put(packageName, DocumentHelper.createDocument());
            return null;
        }
    }
}

