/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.configuration;

import com.liferay.petra.xml.Dom4jUtil;
import com.liferay.source.formatter.checks.configuration.SourceFormatterSuppressions;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.CheckType;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class SuppressionsLoader {
    private static final String _CHECK_ATTRIBUTE_NAME = "checks";
    private static final String _CHECKSTYLE_ATTRIBUTE_NAME = "checkstyle";
    private static final String _FILE_REGEX_ATTRIBUTE_NAME = "files";
    private static final String _SOURCE_CHECK_ATTRIBUTE_NAME = "source-check";
    private static String _portalFileLocation;

    public static SourceFormatterSuppressions loadSuppressions(String baseDirName, List<File> files) throws Exception {
        SourceFormatterSuppressions sourceFormatterSuppressions = new SourceFormatterSuppressions();
        for (File file : files) {
            String content = FileUtil.read(file);
            Document document = SourceUtil.readXML(content);
            Element rootElement = document.getRootElement();
            String absolutePath = SourceUtil.getAbsolutePath(file);
            if (absolutePath.endsWith("checkstyle-suppressions.xml")) {
                sourceFormatterSuppressions = SuppressionsLoader._loadCheckstyleSuppressions(sourceFormatterSuppressions, rootElement, absolutePath, true);
                continue;
            }
            if (absolutePath.endsWith("source-formatter-suppressions.xml")) {
                sourceFormatterSuppressions = SuppressionsLoader._loadCheckstyleSuppressions(sourceFormatterSuppressions, rootElement.element(_CHECKSTYLE_ATTRIBUTE_NAME), absolutePath, false);
                sourceFormatterSuppressions = SuppressionsLoader._loadSourceChecksSuppressions(sourceFormatterSuppressions, rootElement.element(_SOURCE_CHECK_ATTRIBUTE_NAME), absolutePath, SuppressionsLoader._getPortalFileLocation(baseDirName), false);
                continue;
            }
            if (!absolutePath.endsWith("sourcechecks-suppressions.xml")) continue;
            sourceFormatterSuppressions = SuppressionsLoader._loadSourceChecksSuppressions(sourceFormatterSuppressions, rootElement, absolutePath, SuppressionsLoader._getPortalFileLocation(baseDirName), true);
        }
        return sourceFormatterSuppressions;
    }

    private static String _getFileLocation(String absolutePath) {
        int pos = absolutePath.lastIndexOf(47);
        return absolutePath.substring(0, pos + 1);
    }

    private static String _getPortalFileLocation(String baseDirName) {
        if (_portalFileLocation != null) {
            return _portalFileLocation;
        }
        File portalImplDir = SourceFormatterUtil.getFile(baseDirName, "portal-impl", 7);
        if (portalImplDir == null) {
            return null;
        }
        _portalFileLocation = SuppressionsLoader._getFileLocation(SourceUtil.getAbsolutePath(portalImplDir));
        return _portalFileLocation;
    }

    private static SourceFormatterSuppressions _loadCheckstyleSuppressions(SourceFormatterSuppressions sourceFormatterSuppressions, Element suppressionsElement, String absolutePath, boolean moveToSourceFormatterSuppressionsFile) throws Exception {
        if (suppressionsElement == null) {
            return sourceFormatterSuppressions;
        }
        List suppressElements = suppressionsElement.elements("suppress");
        if (moveToSourceFormatterSuppressionsFile) {
            SuppressionsLoader._moveSuppressionsToSourceFormatterSuppressionsFile(absolutePath, suppressElements, _CHECKSTYLE_ATTRIBUTE_NAME);
        }
        for (Element suppressElement : suppressElements) {
            sourceFormatterSuppressions.addSuppression(CheckType.CHECKSTYLE, null, suppressElement.attributeValue(_CHECK_ATTRIBUTE_NAME), suppressElement.attributeValue(_FILE_REGEX_ATTRIBUTE_NAME));
        }
        return sourceFormatterSuppressions;
    }

    private static SourceFormatterSuppressions _loadSourceChecksSuppressions(SourceFormatterSuppressions sourceFormatterSuppressions, Element suppressionsElement, String absolutePath, String portalFileLocation, boolean moveToSourceFormatterSuppressionsFile) throws Exception {
        if (suppressionsElement == null) {
            return sourceFormatterSuppressions;
        }
        List suppressElements = suppressionsElement.elements("suppress");
        if (moveToSourceFormatterSuppressionsFile) {
            SuppressionsLoader._moveSuppressionsToSourceFormatterSuppressionsFile(absolutePath, suppressElements, _SOURCE_CHECK_ATTRIBUTE_NAME);
        }
        String suppressionsFileLocation = SuppressionsLoader._getFileLocation(absolutePath);
        for (Element suppressElement : suppressElements) {
            String fileNameRegex = suppressElement.attributeValue(_FILE_REGEX_ATTRIBUTE_NAME);
            if (Objects.equals(portalFileLocation, suppressionsFileLocation)) {
                fileNameRegex = portalFileLocation + fileNameRegex;
            }
            sourceFormatterSuppressions.addSuppression(CheckType.SOURCE_CHECK, suppressionsFileLocation, suppressElement.attributeValue(_CHECK_ATTRIBUTE_NAME), fileNameRegex);
        }
        return sourceFormatterSuppressions;
    }

    private static void _moveSuppressionsToSourceFormatterSuppressionsFile(String absolutePath, List<Element> suppressElements, String name) throws Exception {
        int pos = absolutePath.lastIndexOf(47);
        String sourceFormatterSuppressionsFileName = absolutePath.substring(0, pos + 1) + "source-formatter-suppressions.xml";
        File sourceFormatterSuppressionsFile = new File(sourceFormatterSuppressionsFileName);
        boolean modified = false;
        Document document = null;
        Element rootElement = null;
        if (sourceFormatterSuppressionsFile.exists()) {
            document = SourceUtil.readXML(FileUtil.read(sourceFormatterSuppressionsFile));
            rootElement = document.getRootElement();
        } else {
            document = DocumentHelper.createDocument();
            rootElement = document.addElement("suppressions");
            modified = true;
        }
        Element checkTypeElement = rootElement.element(name);
        if (checkTypeElement == null) {
            checkTypeElement = rootElement.addElement(name);
            modified = true;
        }
        block0: for (Element suppressElement : suppressElements) {
            List childElements = checkTypeElement.elements();
            for (Element childElement : childElements) {
                if (!Objects.equals(suppressElement.asXML(), childElement.asXML())) continue;
                continue block0;
            }
            suppressElement.detach();
            checkTypeElement.add(suppressElement);
            modified = true;
        }
        if (modified) {
            FileUtil.write(sourceFormatterSuppressionsFile, Dom4jUtil.toString((Node)document));
            System.out.println(sourceFormatterSuppressionsFileName);
        }
    }
}

