/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LanguageKeysCheck
extends BaseFileCheck {
    protected final Pattern languageKeyPattern = Pattern.compile("LanguageUtil.(?:get|format)\\([^;%]+|Liferay.Language.get\\('([^']+)");
    private final Pattern _applyLangMergerPluginPattern = Pattern.compile("^apply[ \t]+plugin[ \t]*:[ \t]+\"com.liferay.lang.merger\"$", 8);
    private final Map<String, Properties> _buildGradleLanguagePropertiesMap = new HashMap<String, Properties>();
    private final Map<String, Properties> _langModuleLanguagePropertiesMap = new HashMap<String, Properties>();
    private final Pattern _mergeLangPattern = Pattern.compile("mergeLang \\{\\s*sourceDirs = \\[(.*?)\\]", 32);
    private final Pattern _metaAnnotationDescriptionParameterPattern = Pattern.compile("@Meta\\.(?:AD|OCD)\\([^\\{]*?description\\s*=\\s*\"(.+?)\"");
    private final Pattern _metaAnnotationNameParameterPattern = Pattern.compile("@Meta\\.(?:AD|OCD)\\([^\\{]*?name\\s*=\\s*\"(.+?)\"");
    private final Map<String, Properties> _moduleLanguagePropertiesMap = new HashMap<String, Properties>();
    private Properties _portalLanguageProperties;

    @Override
    public void init() throws Exception {
        this._portalLanguageProperties = this._getPortalLanguageProperties();
    }

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (this._portalLanguageProperties != null) {
            this._checkLanguageKeys(fileName, absolutePath, content, this.getPatterns());
        }
        return content;
    }

    protected List<Pattern> getPatterns() {
        return Arrays.asList(this.languageKeyPattern, this._metaAnnotationDescriptionParameterPattern, this._metaAnnotationNameParameterPattern);
    }

    private void _checkLanguageKeys(String fileName, String absolutePath, String content, List<Pattern> patterns) throws Exception {
        if (fileName.endsWith(".vm")) {
            return;
        }
        for (Pattern pattern : patterns) {
            this._checkLanguageKeys(fileName, absolutePath, content, pattern);
        }
    }

    private void _checkLanguageKeys(String fileName, String absolutePath, String content, Pattern pattern) throws Exception {
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String[] languageKeys;
            for (String languageKey : languageKeys = this._getLanguageKeys(matcher)) {
                Properties bndLanguageProperties;
                BNDSettings bndSettings;
                Properties langModuleLanguageProperties;
                Properties buildGradleLanguageProperties;
                Properties moduleLanguageProperties;
                if (Validator.isNumber(languageKey) || languageKey.endsWith("}") || languageKey.endsWith("-") || languageKey.endsWith("[") || languageKey.endsWith(".") || languageKey.endsWith("_") || languageKey.startsWith("-") || languageKey.startsWith("$") || languageKey.startsWith("[") || languageKey.startsWith("{") || languageKey.startsWith(".") || languageKey.startsWith("_") || this._portalLanguageProperties.containsKey(languageKey) || (moduleLanguageProperties = this._getModuleLanguageProperties(fileName)) != null && moduleLanguageProperties.containsKey(languageKey) || (buildGradleLanguageProperties = this._getBuildGradleLanguageProperties(absolutePath)) != null && buildGradleLanguageProperties.containsKey(languageKey) || (langModuleLanguageProperties = this._getLangModuleLanguageProperties(absolutePath)) != null && langModuleLanguageProperties.containsKey(languageKey) || (bndSettings = this.getBNDSettings(fileName)) != null && ((bndLanguageProperties = this._getBNDLanguageProperties(bndSettings)) == null || bndLanguageProperties.containsKey(languageKey))) continue;
                this.addMessage(fileName, "Missing language key '" + languageKey + "'");
            }
        }
    }

    private Properties _getBNDLanguageProperties(BNDSettings bndSettings) throws Exception {
        Properties bndFileLanguageProperties = bndSettings.getLanguageProperties();
        this.putBNDSettings(bndSettings);
        return bndFileLanguageProperties;
    }

    private Properties _getBuildGradleLanguageProperties(String absolutePath) throws Exception {
        File file;
        Properties properties = this._buildGradleLanguagePropertiesMap.get(absolutePath);
        if (properties != null) {
            return properties;
        }
        String buildGradleContent = null;
        String buildGradleFileLocation = absolutePath;
        while (true) {
            int pos;
            if ((pos = buildGradleFileLocation.lastIndexOf("/")) == -1) {
                return null;
            }
            file = new File((buildGradleFileLocation = buildGradleFileLocation.substring(0, pos + 1)) + "build.gradle");
            if (file.exists()) break;
            buildGradleFileLocation = StringUtil.replaceLast(buildGradleFileLocation, '/', "");
        }
        buildGradleContent = FileUtil.read(file);
        Matcher matcher = this._applyLangMergerPluginPattern.matcher(buildGradleContent);
        if (!matcher.find()) {
            return null;
        }
        String moduleLocation = StringUtil.replaceLast(buildGradleFileLocation, '/', "");
        List<String> moduleLangDirNames = this._getModuleLangDirNames(moduleLocation, buildGradleContent);
        properties = new Properties();
        for (String moduleLangDirName : moduleLangDirNames) {
            String moduleLangLanguagePropertiesFileName = moduleLangDirName + "/Language.properties";
            File file2 = new File(moduleLangLanguagePropertiesFileName);
            if (!file2.exists()) continue;
            FileInputStream inputStream = new FileInputStream(file2);
            properties.load(inputStream);
        }
        this._buildGradleLanguagePropertiesMap.put(absolutePath, properties);
        return properties;
    }

    private Properties _getLangModuleLanguageProperties(String absolutePath) throws Exception {
        if (!this.isModulesFile(absolutePath)) {
            return null;
        }
        Properties properties = this._langModuleLanguagePropertiesMap.get(absolutePath);
        if (properties != null) {
            return properties;
        }
        String langModulePath = null;
        String fileLocation = absolutePath;
        int x = fileLocation.length();
        block0: while (true) {
            if ((x = fileLocation.lastIndexOf(47, x - 1)) == -1) {
                return null;
            }
            if ((fileLocation = fileLocation.substring(0, x)).endsWith("/modules") || this.isSubrepository() && FileUtil.exists(fileLocation + "/gradle.properties")) {
                return null;
            }
            File directory = new File(fileLocation);
            File[] fileArray = directory.listFiles(File::isDirectory);
            int n = fileArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                File subdirectory = fileArray[n2];
                String subdirectoryPath = subdirectory.getAbsolutePath();
                if (subdirectoryPath.endsWith("-lang")) {
                    langModulePath = subdirectoryPath;
                    break block0;
                }
                ++n2;
            }
            break;
        }
        List<String> languagePropertyFileNames = SourceFormatterUtil.scanForFiles(langModulePath, new String[0], new String[]{"**/resources/content/Language.properties"}, new SourceFormatterExcludes(), true);
        if (languagePropertyFileNames.isEmpty()) {
            return null;
        }
        properties = new Properties();
        properties.load(new FileInputStream(new File(languagePropertyFileNames.get(0))));
        this._langModuleLanguagePropertiesMap.put(absolutePath, properties);
        return properties;
    }

    private String[] _getLanguageKeys(Matcher matcher) {
        int groupCount = matcher.groupCount();
        if (groupCount == 1) {
            String languageKey = matcher.group(1);
            if (Validator.isNotNull(languageKey)) {
                return new String[]{languageKey};
            }
        } else if (groupCount == 2) {
            String languageKey = matcher.group(2);
            languageKey = TextFormatter.format(languageKey, 10);
            return new String[]{languageKey};
        }
        StringBundler sb = new StringBundler();
        String match = matcher.group();
        int count = 0;
        for (int i = 0; i < match.length(); ++i) {
            char c = match.charAt(i);
            if (c == ')') {
                if (count <= 1) {
                    return new String[0];
                }
                --count;
                continue;
            }
            if (c == '(') {
                ++count;
                continue;
            }
            if (c != '\"' || count > 1) continue;
            while (i < match.length()) {
                if (match.charAt(++i) == '\"') {
                    String languageKey = sb.toString();
                    if (match.startsWith("names")) {
                        return StringUtil.split(languageKey);
                    }
                    return new String[]{languageKey};
                }
                sb.append(match.charAt(i));
            }
        }
        return new String[0];
    }

    private List<String> _getModuleLangDirNames(String moduleLocation, String buildGradleContent) {
        ArrayList<String> moduleLangDirNames = new ArrayList<String>();
        Matcher matcher = this._mergeLangPattern.matcher(buildGradleContent);
        if (matcher.find()) {
            String[] sourceDirs;
            for (String sourceDir : sourceDirs = StringUtil.split(matcher.group(1))) {
                sourceDir = StringUtil.trim(sourceDir);
                moduleLangDirNames.add(moduleLocation + "/" + sourceDir.substring(1, sourceDir.length() - 1));
            }
            return moduleLangDirNames;
        }
        int x = moduleLocation.lastIndexOf("/");
        String baseModuleName = moduleLocation.substring(0, x);
        int y = baseModuleName.lastIndexOf("/");
        baseModuleName = baseModuleName.substring(y + 1);
        String moduleLangDirName = moduleLocation.substring(0, x + 1) + baseModuleName + "-lang/src/main/resources/content";
        File moduleLangDir = new File(moduleLangDirName);
        if (!moduleLangDir.exists() && moduleLangDirName.contains("/modules/ee/")) {
            moduleLangDirName = StringUtil.replaceFirst(moduleLangDirName, "/modules/ee/", "/modules/");
        }
        moduleLangDirNames.add(moduleLangDirName);
        return moduleLangDirNames;
    }

    private Properties _getModuleLanguageProperties(String fileName) {
        Properties properties = this._moduleLanguagePropertiesMap.get(fileName);
        if (properties != null) {
            return properties;
        }
        StringBundler sb = new StringBundler(3);
        int pos = fileName.indexOf("/docroot/");
        if (pos != -1) {
            sb.append(fileName.substring(0, pos + 9));
            sb.append("WEB-INF/src/");
        } else {
            pos = fileName.indexOf("src/");
            if (pos == -1) {
                return null;
            }
            sb.append(fileName.substring(0, pos + 4));
            if (fileName.contains("src/main/")) {
                sb.append("main/resources/");
            }
        }
        sb.append("content/Language.properties");
        try {
            properties = new Properties();
            FileInputStream inputStream = new FileInputStream(sb.toString());
            properties.load(inputStream);
            this._moduleLanguagePropertiesMap.put(fileName, properties);
            return properties;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Properties _getPortalLanguageProperties() throws Exception {
        String portalLanguagePropertiesContent = this.getPortalContent("portal-impl/src/content/Language.properties");
        if (portalLanguagePropertiesContent == null) {
            return null;
        }
        Properties portalLanguageProperties = new Properties();
        portalLanguageProperties.load(new StringReader(portalLanguagePropertiesContent));
        return portalLanguageProperties;
    }
}

