/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class JavaDeprecatedJavadocCheck
extends BaseFileCheck {
    private final Pattern _deprecatedPattern = Pattern.compile("(\n\\s*\\* @deprecated)( As of ([0-9\\.]+)(.*?)\n\\s*\\*( @|/))?", 32);
    private ComparableVersion _mainReleaseComparableVersion;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        content = this._formatDeprecatedJavadoc(fileName, absolutePath, content);
        return content;
    }

    private String _formatDeprecatedJavadoc(String fileName, String absolutePath, String content) throws Exception {
        ComparableVersion mainReleaseComparableVersion = this._getMainReleaseComparableVersion(fileName, absolutePath);
        if (mainReleaseComparableVersion == null) {
            return content;
        }
        Matcher matcher = this._deprecatedPattern.matcher(content);
        while (matcher.find()) {
            if (matcher.group(2) == null) {
                return StringUtil.insert(content, " As of " + mainReleaseComparableVersion.toString(), matcher.end(1));
            }
            String version = matcher.group(3);
            ComparableVersion comparableVersion = new ComparableVersion(version);
            if (comparableVersion.compareTo(mainReleaseComparableVersion) > 0) {
                return StringUtil.replaceFirst(content, version, mainReleaseComparableVersion.toString(), matcher.start());
            }
            if (StringUtil.count(version, '.') == 1) {
                return StringUtil.insert(content, ".0", matcher.end(3));
            }
            String deprecatedInfo = matcher.group(4);
            if (Validator.isNull(deprecatedInfo)) {
                return content;
            }
            if (!deprecatedInfo.startsWith(",")) {
                return StringUtil.insert(content, ",", matcher.end(3));
            }
            if (!deprecatedInfo.endsWith(".") || deprecatedInfo.matches("[\\S\\s]*\\.[ \n][\\S\\s]*")) continue;
            return StringUtil.replaceFirst(content, ".", "", matcher.end(4) - 1);
        }
        return content;
    }

    private ComparableVersion _getMainReleaseComparableVersion(String fileName, String absolutePath) throws Exception {
        boolean usePortalReleaseVersion = false;
        if (this.isPortalSource() && !this.isModulesFile(absolutePath)) {
            usePortalReleaseVersion = true;
        }
        String releaseVersion = "";
        if (usePortalReleaseVersion) {
            if (this._mainReleaseComparableVersion != null) {
                return this._mainReleaseComparableVersion;
            }
            releaseVersion = ReleaseInfo.getVersion();
        } else {
            BNDSettings bndSettings = this.getBNDSettings(fileName);
            if (bndSettings == null) {
                return null;
            }
            releaseVersion = bndSettings.getReleaseVersion();
            if (releaseVersion == null) {
                return null;
            }
            this.putBNDSettings(bndSettings);
        }
        int pos = releaseVersion.lastIndexOf(46);
        String mainReleaseVersion = releaseVersion.substring(0, pos) + ".0";
        ComparableVersion mainReleaseComparableVersion = new ComparableVersion(mainReleaseVersion);
        if (usePortalReleaseVersion) {
            this._mainReleaseComparableVersion = mainReleaseComparableVersion;
        }
        return mainReleaseComparableVersion;
    }
}

