/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPSubnameCheck
extends BaseFileCheck {
    private final Pattern _subnamePattern = Pattern.compile("\\s(_?sub[A-Z]\\w+)[; ]");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = this._subnamePattern.matcher(content);
        while (matcher.find()) {
            this.addMessage(fileName, "'sub' should be followed by a lowercase character for '" + matcher.group(1) + "'");
        }
        return content;
    }
}

