/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.EmptyLinesCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSSEmptyLinesCheck
extends EmptyLinesCheck {
    private final Pattern _emptyLineAfterOpenCurlyBrace = Pattern.compile("\\{\n\n\t*(?!(/\\* --|//))\\S");
    private final Pattern _emptyLineBeforeCloseCurlyBrace = Pattern.compile("\n\n\t*\\}");
    private final Pattern _missingEmptyLineAfterComment = Pattern.compile("-- \\*/\n.");
    private final Pattern _missingEmptyLineBeforeComment = Pattern.compile(".\n\t*/\\* --");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this.fixMissingEmptyLinesAroundComments(content);
        return this._fixEmptyLines(content);
    }

    private String _fixEmptyLines(String content) {
        Matcher matcher = this._emptyLineAfterOpenCurlyBrace.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        matcher = this._emptyLineBeforeCloseCurlyBrace.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        matcher = this._missingEmptyLineAfterComment.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
        }
        matcher = this._missingEmptyLineBeforeComment.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
        }
        return content;
    }
}

