/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.checks.SourceCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.CheckType;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class BaseSourceCheck
implements SourceCheck {
    protected static final String RUN_OUTSIDE_PORTAL_EXCLUDES = "run.outside.portal.excludes";
    private String _baseDirName;
    private boolean _enabled = true;
    private int _maxLineLength;
    private List<String> _pluginsInsideModulesDirectoryNames;
    private boolean _portalSource;
    private String _projectPathPrefix;
    private Map<String, Properties> _propertiesMap;
    private SourceFormatterExcludes _sourceFormatterExcludes;
    private final Map<String, Set<SourceFormatterMessage>> _sourceFormatterMessagesMap = new ConcurrentHashMap<String, Set<SourceFormatterMessage>>();
    private boolean _subrepository;

    @Override
    public Set<SourceFormatterMessage> getSourceFormatterMessages(String fileName) {
        if (this._sourceFormatterMessagesMap.containsKey(fileName)) {
            return this._sourceFormatterMessagesMap.get(fileName);
        }
        return Collections.emptySet();
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public boolean isModulesCheck() {
        return false;
    }

    @Override
    public boolean isPortalCheck() {
        return false;
    }

    @Override
    public void setAllFileNames(List<String> allFileNames) {
    }

    @Override
    public void setBaseDirName(String baseDirName) {
        this._baseDirName = baseDirName;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    @Override
    public void setMaxLineLength(int maxLineLength) {
        this._maxLineLength = maxLineLength;
    }

    @Override
    public void setPluginsInsideModulesDirectoryNames(List<String> pluginsInsideModulesDirectoryNames) {
        this._pluginsInsideModulesDirectoryNames = pluginsInsideModulesDirectoryNames;
    }

    @Override
    public void setPortalSource(boolean portalSource) {
        this._portalSource = portalSource;
    }

    @Override
    public void setProjectPathPrefix(String projectPathPrefix) {
        this._projectPathPrefix = projectPathPrefix;
    }

    @Override
    public void setPropertiesMap(Map<String, Properties> propertiesMap) {
        this._propertiesMap = propertiesMap;
    }

    @Override
    public void setSourceFormatterExcludes(SourceFormatterExcludes sourceFormatterExcludes) {
        this._sourceFormatterExcludes = sourceFormatterExcludes;
    }

    @Override
    public void setSubrepository(boolean subrepository) {
        this._subrepository = subrepository;
    }

    protected void addMessage(String fileName, String message) {
        this.addMessage(fileName, message, -1);
    }

    protected void addMessage(String fileName, String message, int lineCount) {
        this.addMessage(fileName, message, null, lineCount);
    }

    protected void addMessage(String fileName, String message, String markdownFileName) {
        this.addMessage(fileName, message, markdownFileName, -1);
    }

    protected void addMessage(String fileName, String message, String markdownFileName, int lineCount) {
        Set<SourceFormatterMessage> sourceFormatterMessages = this._sourceFormatterMessagesMap.get(fileName);
        if (sourceFormatterMessages == null) {
            sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
        }
        Class<?> clazz = this.getClass();
        sourceFormatterMessages.add(new SourceFormatterMessage(fileName, message, CheckType.SOURCE_CHECK, clazz.getSimpleName(), markdownFileName, lineCount));
        this._sourceFormatterMessagesMap.put(fileName, sourceFormatterMessages);
    }

    protected void clearSourceFormatterMessages(String fileName) {
        this._sourceFormatterMessagesMap.remove(fileName);
    }

    protected String getBaseDirName() {
        return this._baseDirName;
    }

    protected Map<String, String> getCompatClassNamesMap() throws Exception {
        HashMap<String, String> compatClassNamesMap = new HashMap<String, String>();
        String[] includes = new String[]{"**/portal-compat-shared/src/com/liferay/compat/**/*.java"};
        String baseDirName = this._baseDirName;
        List<Object> fileNames = new ArrayList();
        for (int i = 0; i < 3; ++i) {
            File sharedDir = new File(baseDirName + "shared");
            if (sharedDir.exists()) {
                fileNames = this.getFileNames(baseDirName, new String[0], includes);
                break;
            }
            baseDirName = baseDirName + "../";
        }
        for (String fileName : fileNames) {
            File file = new File(fileName);
            String content = FileUtil.read(file);
            fileName = StringUtil.replace(fileName, '\\', '/');
            fileName = StringUtil.replace(fileName, '/', '.');
            int pos = fileName.indexOf("com.");
            String compatClassName = fileName.substring(pos);
            compatClassName = compatClassName.substring(0, compatClassName.length() - 5);
            String extendedClassName = StringUtil.replace(compatClassName, "compat.", "");
            if (!content.contains("extends " + extendedClassName)) continue;
            compatClassNamesMap.put(compatClassName, extendedClassName);
        }
        return compatClassNamesMap;
    }

    protected String getContent(String fileName, int level) throws Exception {
        return SourceFormatterUtil.getContent(this._baseDirName, fileName, level);
    }

    protected Document getCustomSQLDocument(String fileName, String absolutePath, Document portalCustomSQLDocument) throws Exception {
        if (this.isPortalSource() && !this.isModulesFile(absolutePath)) {
            return portalCustomSQLDocument;
        }
        int i = fileName.lastIndexOf("/src/");
        if (i == -1) {
            return null;
        }
        File customSQLFile = new File(fileName.substring(0, i) + "/src/custom-sql/default.xml");
        if (!customSQLFile.exists()) {
            customSQLFile = new File(fileName.substring(0, i) + "/src/main/resources/META-INF/custom-sql/default.xml");
        }
        if (!customSQLFile.exists()) {
            customSQLFile = new File(fileName.substring(0, i) + "/src/main/resources/custom-sql/default.xml");
        }
        if (!customSQLFile.exists()) {
            return null;
        }
        return SourceUtil.readXML(customSQLFile);
    }

    protected File getFile(String fileName, int level) {
        return SourceFormatterUtil.getFile(this._baseDirName, fileName, level);
    }

    protected List<String> getFileNames(String baseDirName, String[] excludes, String[] includes) throws Exception {
        return SourceFormatterUtil.scanForFiles(baseDirName, excludes, includes, this._sourceFormatterExcludes, true);
    }

    protected int getLeadingTabCount(String line) {
        int leadingTabCount = 0;
        while (line.startsWith("\t")) {
            line = line.substring(1);
            ++leadingTabCount;
        }
        return leadingTabCount;
    }

    protected int getLevel(String s) {
        return SourceUtil.getLevel(s);
    }

    protected int getLevel(String s, String increaseLevelString, String decreaseLevelString) {
        return SourceUtil.getLevel(s, increaseLevelString, decreaseLevelString);
    }

    protected int getLevel(String s, String[] increaseLevelStrings, String[] decreaseLevelStrings) {
        return SourceUtil.getLevel(s, increaseLevelStrings, decreaseLevelStrings);
    }

    protected int getLevel(String s, String[] increaseLevelStrings, String[] decreaseLevelStrings, int startLevel) {
        return SourceUtil.getLevel(s, increaseLevelStrings, decreaseLevelStrings, startLevel);
    }

    protected String getLine(String content, int lineCount) {
        int nextLineStartPos = this.getLineStartPos(content, lineCount);
        if (nextLineStartPos == -1) {
            return null;
        }
        int nextLineEndPos = content.indexOf(10, nextLineStartPos);
        if (nextLineEndPos == -1) {
            return content.substring(nextLineStartPos);
        }
        return content.substring(nextLineStartPos, nextLineEndPos);
    }

    protected int getLineCount(String content, int pos) {
        return StringUtil.count(content, 0, pos, '\n') + 1;
    }

    protected int getLineStartPos(String content, int lineCount) {
        int x = 0;
        for (int i = 1; i < lineCount; ++i) {
            if ((x = content.indexOf(10, x + 1)) != -1) continue;
            return x;
        }
        return x + 1;
    }

    protected int getMaxLineLength() {
        return this._maxLineLength;
    }

    protected List<String> getPluginsInsideModulesDirectoryNames() {
        return this._pluginsInsideModulesDirectoryNames;
    }

    protected String getPortalContent(String fileName) throws Exception {
        String portalBranchName = SourceFormatterUtil.getPropertyValue("git.liferay.portal.branch", this._propertiesMap);
        return SourceFormatterUtil.getPortalContent(this._baseDirName, portalBranchName, fileName);
    }

    protected Document getPortalCustomSQLDocument() throws Exception {
        if (!this.isPortalSource()) {
            return null;
        }
        String portalCustomSQLDefaultContent = this.getPortalContent("portal-impl/src/custom-sql/default.xml");
        if (portalCustomSQLDefaultContent == null) {
            return null;
        }
        Document document = DocumentHelper.createDocument();
        Element rootElement = document.addElement("custom-sql");
        Document customSQLDefaultDocument = SourceUtil.readXML(portalCustomSQLDefaultContent);
        Element customSQLDefaultRootElement = customSQLDefaultDocument.getRootElement();
        for (Element sqlElement : customSQLDefaultRootElement.elements("sql")) {
            String customSQLFileContent = this.getPortalContent("portal-impl/src/" + sqlElement.attributeValue("file"));
            if (customSQLFileContent == null) continue;
            Document customSQLDocument = SourceUtil.readXML(customSQLFileContent);
            Element customSQLRootElement = customSQLDocument.getRootElement();
            for (Element customSQLElement : customSQLRootElement.elements("sql")) {
                rootElement.add(customSQLElement.detach());
            }
        }
        return document;
    }

    protected File getPortalDir() {
        File portalImplDir = SourceFormatterUtil.getFile(this.getBaseDirName(), "portal-impl", 7);
        if (portalImplDir == null) {
            return null;
        }
        return portalImplDir.getParentFile();
    }

    protected String getProjectPathPrefix() {
        return this._projectPathPrefix;
    }

    protected Map<String, Properties> getPropertiesMap() {
        return this._propertiesMap;
    }

    protected SourceFormatterExcludes getSourceFormatterExcludes() {
        return this._sourceFormatterExcludes;
    }

    protected boolean isExcludedPath(Properties properties, String key, String path, int lineCount, String parameter) {
        List<String> excludes = ListUtil.fromString(GetterUtil.getString(properties.getProperty(key)), ",");
        if (ListUtil.isEmpty(excludes)) {
            return false;
        }
        String pathWithParameter = null;
        if (Validator.isNotNull(parameter)) {
            pathWithParameter = path + "@" + parameter;
        }
        String pathWithLineCount = null;
        if (lineCount > 0) {
            pathWithLineCount = path + "@" + lineCount;
        }
        for (String exclude : excludes) {
            if (Validator.isNull(exclude)) continue;
            if (exclude.startsWith("**")) {
                exclude = exclude.substring(2);
            }
            if (!(exclude.endsWith("**") ? path.contains(exclude = exclude.substring(0, exclude.length() - 2)) : path.endsWith(exclude) || pathWithParameter != null && pathWithParameter.endsWith(exclude) || pathWithLineCount != null && pathWithLineCount.endsWith(exclude))) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcludedPath(String key, String path) {
        return this.isExcludedPath(key, path, -1);
    }

    protected boolean isExcludedPath(String key, String path, int lineCount) {
        return this.isExcludedPath(key, path, lineCount, null);
    }

    protected boolean isExcludedPath(String key, String path, int lineCount, String parameter) {
        for (Map.Entry<String, Properties> entry : this._propertiesMap.entrySet()) {
            String propertiesFileLocation = entry.getKey();
            if (!path.startsWith(propertiesFileLocation) || !this.isExcludedPath(entry.getValue(), key, path, lineCount, parameter)) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcludedPath(String key, String path, String parameter) {
        return this.isExcludedPath(key, path, -1, parameter);
    }

    protected boolean isModulesApp(String absolutePath, boolean privateOnly) {
        if (absolutePath.contains("/modules/private/apps/") || !privateOnly && absolutePath.contains("/modules/apps/")) {
            return true;
        }
        if (this._projectPathPrefix == null) {
            return false;
        }
        return this._projectPathPrefix.startsWith(":private:apps") || !privateOnly && this._projectPathPrefix.startsWith(":apps:");
    }

    protected boolean isModulesFile(String absolutePath) {
        return this.isModulesFile(absolutePath, null);
    }

    protected boolean isModulesFile(String absolutePath, List<String> pluginsInsideModulesDirectoryNames) {
        if (this._subrepository) {
            return true;
        }
        if (pluginsInsideModulesDirectoryNames == null) {
            return absolutePath.contains("/modules/");
        }
        try {
            for (String directoryName : pluginsInsideModulesDirectoryNames) {
                if (!absolutePath.contains(directoryName)) continue;
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return absolutePath.contains("/modules/");
    }

    protected boolean isPortalSource() {
        return this._portalSource;
    }

    protected boolean isSubrepository() {
        return this._subrepository;
    }

    protected String stripQuotes(String s) {
        return this.stripQuotes(s, '\'', '\"');
    }

    protected String stripQuotes(String s, char ... delimeters) {
        List<Character> delimetersList = ListUtil.toList(delimeters);
        char delimeter = ' ';
        boolean insideQuotes = false;
        StringBundler sb = new StringBundler();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (insideQuotes) {
                if (c != delimeter) continue;
                int precedingBackSlashCount = 0;
                for (int j = i - 1; j >= 0 && s.charAt(j) == '\\'; --j) {
                    ++precedingBackSlashCount;
                }
                if (precedingBackSlashCount != 0 && precedingBackSlashCount % 2 != 0) continue;
                insideQuotes = false;
                continue;
            }
            if (delimetersList.contains(Character.valueOf(c))) {
                delimeter = c;
                insideQuotes = true;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

