/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public final class TokenTypesDoclet {
    private static final String DEST_FILE_OPT = "-destfile";

    private TokenTypesDoclet() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean start(RootDoc root) throws FileNotFoundException {
        String fileName = TokenTypesDoclet.getDestFileName(root.options());
        FileOutputStream fos = new FileOutputStream(fileName);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
        try (PrintWriter writer = new PrintWriter((Writer)osw, false);){
            FieldDoc[] fields;
            ClassDoc[] classes = root.classes();
            for (FieldDoc field : fields = classes[0].fields()) {
                String firstSentence;
                if (!field.isStatic() || !field.isPublic() || !field.isFinal() || !"int".equals(field.type().qualifiedTypeName())) continue;
                if (field.firstSentenceTags().length == 1) {
                    firstSentence = field.firstSentenceTags()[0].text();
                } else if (Arrays.stream(field.firstSentenceTags()).filter(tag -> !"Text".equals(tag.name())).count() == 1L) {
                    firstSentence = field.firstSentenceTags()[0].text() + "<code>" + field.firstSentenceTags()[1].text() + "</code>" + field.firstSentenceTags()[2].text();
                } else {
                    List<Tag> tags = Arrays.asList(field.firstSentenceTags());
                    String joinedTags = tags.stream().map(Tag::toString).collect(Collectors.joining("\", \"", "[\"", "\"]"));
                    String message = String.format(Locale.ROOT, "Should be only one tag for %s. Tags %s.", field.toString(), joinedTags);
                    throw new IllegalArgumentException(message);
                }
                writer.println(field.name() + "=" + firstSentence);
            }
        }
        return true;
    }

    public static int optionLength(String option) {
        int length = 0;
        if (DEST_FILE_OPT.equals(option)) {
            length = 2;
        }
        return length;
    }

    public static boolean checkOptions(String[][] options, DocErrorReporter reporter) {
        boolean foundDestFileOption = false;
        boolean onlyOneDestFileOption = true;
        for (String[] opt : options) {
            if (!DEST_FILE_OPT.equals(opt[0])) continue;
            if (foundDestFileOption) {
                reporter.printError("Only one -destfile option allowed.");
                onlyOneDestFileOption = false;
                break;
            }
            foundDestFileOption = true;
        }
        if (!foundDestFileOption) {
            reporter.printError("Usage: javadoc -destfile file -doclet TokenTypesDoclet ...");
        }
        return onlyOneDestFileOption && foundDestFileOption;
    }

    private static String getDestFileName(String[] ... options) {
        String fileName = null;
        for (String[] opt : options) {
            if (!DEST_FILE_OPT.equals(opt[0])) continue;
            fileName = opt[1];
        }
        return fileName;
    }
}

