/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtils;
import java.util.ArrayList;
import java.util.List;

public class JavadocTagContinuationIndentationCheck
extends AbstractJavadocCheck {
    public static final String MSG_KEY = "tag.continuation.indent";
    private static final int DEFAULT_INDENTATION = 4;
    private int offset = 4;

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10073};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (!JavadocTagContinuationIndentationCheck.isInlineDescription(ast)) {
            List<DetailNode> textNodes = JavadocTagContinuationIndentationCheck.getAllNewlineNodes(ast);
            for (DetailNode newlineNode : textNodes) {
                String text;
                DetailNode textNode = JavadocUtils.getNextSibling(JavadocUtils.getNextSibling(newlineNode));
                if (textNode == null || textNode.getType() != 10079 || CommonUtils.isBlank((text = textNode.getText()).trim()) || text.length() > this.offset && text.substring(1, this.offset + 1).trim().isEmpty()) continue;
                this.log(textNode.getLineNumber(), MSG_KEY, this.offset);
            }
        }
    }

    private static List<DetailNode> getAllNewlineNodes(DetailNode descriptionNode) {
        ArrayList<DetailNode> textNodes = new ArrayList<DetailNode>();
        DetailNode node = JavadocUtils.getFirstChild(descriptionNode);
        while (JavadocUtils.getNextSibling(node) != null) {
            if (node.getType() == 6) {
                textNodes.add(node);
            }
            node = JavadocUtils.getNextSibling(node);
        }
        return textNodes;
    }

    private static boolean isInlineDescription(DetailNode description) {
        boolean isInline = false;
        for (DetailNode inlineTag = description.getParent(); inlineTag != null; inlineTag = inlineTag.getParent()) {
            if (inlineTag.getType() != 10077) continue;
            isInline = true;
            break;
        }
        return isInline;
    }
}

