/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class JavadocPackageCheck
extends AbstractFileSetCheck {
    public static final String MSG_LEGACY_PACKAGE_HTML = "javadoc.legacyPackageHtml";
    public static final String MSG_PACKAGE_INFO = "javadoc.packageInfo";
    private final Set<File> directoriesChecked = ConcurrentHashMap.newKeySet();
    private boolean allowLegacy;

    public JavadocPackageCheck() {
        this.setFileExtensions("java");
    }

    @Override
    public void beginProcessing(String charset) {
        super.beginProcessing(charset);
        this.directoriesChecked.clear();
    }

    @Override
    protected void processFiltered(File file, FileText fileText) {
        boolean isDirChecked;
        File dir = file.getParentFile();
        boolean bl = isDirChecked = !this.directoriesChecked.add(dir);
        if (!isDirChecked) {
            File packageInfo = new File(dir, "package-info.java");
            File packageHtml = new File(dir, "package.html");
            if (packageInfo.exists()) {
                if (packageHtml.exists()) {
                    this.log(0, MSG_LEGACY_PACKAGE_HTML, new Object[0]);
                }
            } else if (!this.allowLegacy || !packageHtml.exists()) {
                this.log(0, MSG_PACKAGE_INFO, new Object[0]);
            }
        }
    }

    public void setAllowLegacy(boolean allowLegacy) {
        this.allowLegacy = allowLegacy;
    }
}

