/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AuditEventFormatter;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.util.Locale;

public class AuditEventDefaultFormatter
implements AuditEventFormatter {
    private static final int LENGTH_OF_ALL_SEPARATORS = 10;
    private static final String SUFFIX = "Check";

    @Override
    public String format(AuditEvent event) {
        String fileName = event.getFileName();
        String message = event.getMessage();
        SeverityLevel severityLevel = event.getSeverityLevel();
        String severityLevelName = severityLevel == SeverityLevel.WARNING ? "WARN" : severityLevel.getName().toUpperCase(Locale.US);
        int bufLen = AuditEventDefaultFormatter.calculateBufferLength(event, severityLevelName.length());
        StringBuilder sb = new StringBuilder(bufLen);
        sb.append('[').append(severityLevelName).append("] ").append(fileName).append(':').append(event.getLine());
        if (event.getColumn() > 0) {
            sb.append(':').append(event.getColumn());
        }
        sb.append(": ").append(message).append(" [");
        if (event.getModuleId() == null) {
            String checkShortName = AuditEventDefaultFormatter.getCheckShortName(event);
            sb.append(checkShortName);
        } else {
            sb.append(event.getModuleId());
        }
        sb.append(']');
        return sb.toString();
    }

    private static int calculateBufferLength(AuditEvent event, int severityLevelNameLength) {
        return 10 + event.getFileName().length() + event.getMessage().length() + severityLevelNameLength + AuditEventDefaultFormatter.getCheckShortName(event).length();
    }

    private static String getCheckShortName(AuditEvent event) {
        String checkFullName = event.getSourceName();
        int lastDotIndex = checkFullName.lastIndexOf(46);
        String checkShortName = lastDotIndex == -1 ? (checkFullName.endsWith(SUFFIX) ? checkFullName.substring(0, checkFullName.lastIndexOf(SUFFIX)) : checkFullName.substring(0, checkFullName.length())) : (checkFullName.endsWith(SUFFIX) ? checkFullName.substring(lastDotIndex + 1, checkFullName.lastIndexOf(SUFFIX)) : checkFullName.substring(lastDotIndex + 1, checkFullName.length()));
        return checkShortName;
    }
}

