/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLCustomSQLStylingCheck
extends BaseFileCheck {
    private static final String _CUSTOM_FINDER_SCALABILITY_EXCLUDES = "custom.finder.scalability.excludes";
    private final Pattern _incorrectAndOrpattern = Pattern.compile("(\n\t*)(AND|OR|\\[\\$AND_OR_CONNECTOR\\$\\])( |\n)");
    private final Pattern _incorrectLineBreakAfterCommaPattern = Pattern.compile(".(?<! (ASC|DESC)),\n");
    private final Pattern _missingLineBreakAfterKeywordPattern = Pattern.compile("\n\\s*(.*\\s(BY|FROM|HAVING|JOIN|ON|SELECT|WHERE)) ");
    private final Pattern _missingLineBreakAfterOpenParenthesisPattern = Pattern.compile("(\t+)\\(.+\n");
    private final Pattern _missingLineBreakBeforeOpenParenthesisPattern = Pattern.compile("\n(\t+).*[^\t\n]\\(\n");
    private final Pattern _missingParenthesesPattern1 = Pattern.compile("\t([^\t]*(\\S))\\s+(AND|OR|\\[\\$AND_OR_CONNECTOR\\$\\])\\s*\n");
    private final Pattern _missingParenthesesPattern2 = Pattern.compile("\\s(AND|OR|\\[\\$AND_OR_CONNECTOR\\$\\])\\s+[^\\(\\[<\\s]");
    private final Pattern _multiLineSinglePredicatePattern = Pattern.compile("\t\\(\n(.*)\n\t*\\)");
    private final Pattern _redundantParenthesesForSingleLineClausePattern = Pattern.compile("\\s(ON|WHERE)\\s+\\((.*)\\)\n(.*)\n");
    private final Pattern _singleLineClauseWitMultiplePredicatesPattern = Pattern.compile("\n(\t*)((.*\\)) (AND|OR|\\[\\$AND_OR_CONNECTOR\\$\\]) (\\(.*))");
    private final Pattern _unionPattern = Pattern.compile("(\\S)(\\s+)UNION( ALL)?\\s+(\\S)");
    private final Pattern _whereNotInSQLPattern = Pattern.compile("WHERE\\s.*\\sNOT IN", 32);

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.contains("/custom-sql/")) {
            return content;
        }
        this._checkIncorrectLineBreakAfterComma(fileName, content);
        this._checkMissingLineBreakAfterKeyword(fileName, content);
        this._checkMissingParentheses(fileName, content);
        this._checkMultiLineClause(fileName, content);
        this._checkScalability(fileName, absolutePath, content);
        content = this._fixIncorrectAndOr(content);
        content = this._fixMissingLineBreakAfterOpenParenthesis(content);
        content = this._fixMissingLineBreakBeforeOpenParenthesis(content);
        content = this._fixRedundantParenthesesForSingleLineClause(content);
        content = this._fixSinglePredicateClause(content);
        content = this._formatSingleLineClauseWithMultiplePredicates(fileName, content);
        content = this._formatUnionStatement(fileName, content);
        return content;
    }

    private String _addTabs(String content, int start, int end) {
        for (int i = start; i <= end; ++i) {
            int lineStartPos = this.getLineStartPos(content, i);
            content = content.substring(0, lineStartPos) + "\t" + content.substring(lineStartPos);
        }
        return content;
    }

    private void _checkIncorrectLineBreakAfterComma(String fileName, String content) {
        Matcher matcher = this._incorrectLineBreakAfterCommaPattern.matcher(content);
        while (matcher.find()) {
            this.addMessage(fileName, "Incorrect line break after ','", this.getLineCount(content, matcher.start()));
        }
    }

    private void _checkMissingLineBreakAfterKeyword(String fileName, String content) {
        Matcher matcher = this._missingLineBreakAfterKeywordPattern.matcher(content);
        while (matcher.find()) {
            this.addMessage(fileName, "There should be a line break after '" + StringUtil.trim(matcher.group(1)), this.getLineCount(content, matcher.end()));
        }
    }

    private void _checkMissingParentheses(String fileName, String content) {
        Matcher matcher = this._missingParenthesesPattern1.matcher(content);
        while (matcher.find()) {
            String s;
            String charBeforeOperator = matcher.group(2);
            if (charBeforeOperator.equals(")") ? (s = matcher.group(1)).equals(")") || s.startsWith("(") && this.getLevel(s) == 0 : charBeforeOperator.equals("]") && (s = matcher.group(1)).startsWith("[") && this.getLevel(s, "[", "]") == 0) continue;
            this.addMessage(fileName, "Missing parentheses", this.getLineCount(content, matcher.start()));
        }
        matcher = this._missingParenthesesPattern2.matcher(content);
        while (matcher.find()) {
            String nextLine = this.getLine(content, this.getLineCount(content, matcher.end()));
            if (nextLine.endsWith(" IN") || nextLine.endsWith("EXISTS") || nextLine.matches(".*\\s+BETWEEN\\s+\\?\\s+AND\\s+\\?.*")) continue;
            this.addMessage(fileName, "Missing parentheses", this.getLineCount(content, matcher.end()));
        }
    }

    private void _checkMultiLineClause(String fileName, String content) {
        int startPos = -1;
        while ((startPos = content.indexOf("\t(\n", startPos + 1)) != -1) {
            int startLineStartPos;
            int startLineTabCount;
            int endLineTabCount;
            int endPos = this._getCloseParenthesisPos(content, startPos);
            int endLineCount = this.getLineCount(content, endPos);
            int endLineStartPos = content.lastIndexOf("\n", endPos);
            char c = content.charAt(endPos - 1);
            if (c != '\t') {
                this.addMessage(fileName, "There should be a line break after '" + StringUtil.trim(content.substring(endLineStartPos, endPos)), endLineCount);
                continue;
            }
            String afterCloseParenthesis = StringUtil.trim(content.substring(endPos + 1));
            String beforeOpenParenthesis = StringUtil.trim(content.substring(0, startPos));
            if (!(!beforeOpenParenthesis.endsWith(" ON") && !beforeOpenParenthesis.endsWith("\tWHERE") || afterCloseParenthesis.startsWith("AND") || afterCloseParenthesis.startsWith("OR") || afterCloseParenthesis.startsWith("["))) {
                this.addMessage(fileName, "redundant parentheses", this.getLineCount(content, startPos));
            }
            if ((endLineTabCount = endPos - endLineStartPos - 1) == (startLineTabCount = startPos - (startLineStartPos = content.lastIndexOf("\n", startPos)))) continue;
            this.addMessage(fileName, StringBundler.concat("Line starts with '", String.valueOf(endLineTabCount), "' tabs, but '", String.valueOf(startLineTabCount), "' tabs are expected"), endLineCount);
        }
        return;
    }

    private void _checkScalability(String fileName, String absolutePath, String content) throws Exception {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        for (Element sqlElement : rootElement.elements("sql")) {
            String sql = sqlElement.getText();
            Matcher matcher = this._whereNotInSQLPattern.matcher(sql);
            while (matcher.find()) {
                int x;
                int y;
                String id = sqlElement.attributeValue("id");
                String entityName = id.substring((y = id.lastIndexOf(46, (x = id.lastIndexOf(46)) - 1)) + 1, x);
                if (this.isExcludedPath(_CUSTOM_FINDER_SCALABILITY_EXCLUDES, absolutePath, entityName)) continue;
                this.addMessage(fileName, "Avoid using WHERE ... NOT IN: " + id + ", see LPS-51315");
            }
        }
    }

    private String _fixIncorrectAndOr(String content) {
        Matcher matcher = this._incorrectAndOrpattern.matcher(content);
        if (matcher.find()) {
            String whitespace = matcher.group(3);
            if (whitespace.equals(" ")) {
                return StringUtil.replaceFirst(content, matcher.group(), " " + matcher.group(2) + matcher.group(1), matcher.start() - 1);
            }
            return StringUtil.replaceFirst(content, matcher.group(1), " ", matcher.start() - 1);
        }
        return content;
    }

    private String _fixMissingLineBreakAfterOpenParenthesis(String content) {
        Matcher matcher = this._missingLineBreakAfterOpenParenthesisPattern.matcher(content);
        while (matcher.find()) {
            if (this.getLevel(matcher.group()) == 0) continue;
            int startPos = matcher.end(1);
            int startLineCount = this.getLineCount(content, startPos);
            int endPos = this._getCloseParenthesisPos(content, startPos);
            int endLineCount = this.getLineCount(content, endPos);
            content = this._addTabs(content, startLineCount + 1, endLineCount - 1);
            return StringUtil.replaceFirst(content, "\t(", "\t(\n\t" + matcher.group(1), matcher.start());
        }
        return content;
    }

    private String _fixMissingLineBreakBeforeOpenParenthesis(String content) {
        Matcher matcher = this._missingLineBreakBeforeOpenParenthesisPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        int startPos = matcher.end() - 2;
        int startLineCount = this.getLineCount(content, startPos);
        int endPos = this._getCloseParenthesisPos(content, startPos);
        int endLineCount = this.getLineCount(content, endPos);
        content = this._addTabs(content, startLineCount + 1, endLineCount);
        return StringUtil.replaceFirst(content, "(\n", "\n\t" + matcher.group(1) + "(\n", matcher.start());
    }

    private String _fixRedundantParenthesesForSingleLineClause(String content) {
        Matcher matcher = this._redundantParenthesesForSingleLineClausePattern.matcher(content);
        while (matcher.find()) {
            String trimmedNextLine = StringUtil.trim(matcher.group(3));
            if (trimmedNextLine.startsWith("AND") || trimmedNextLine.startsWith("OR") || trimmedNextLine.startsWith("[$AND_OR_CONNECTOR$]")) continue;
            return StringUtil.replaceFirst(content, "(" + matcher.group(2) + ")", matcher.group(2), matcher.start());
        }
        return content;
    }

    private String _fixSinglePredicateClause(String content) {
        Matcher matcher = this._multiLineSinglePredicatePattern.matcher(content);
        while (matcher.find()) {
            String line = StringUtil.trim(matcher.group(1));
            if (line.startsWith("[") && line.endsWith("]")) continue;
            return StringUtil.replace(content, matcher.group(), "\t(" + line + ")");
        }
        return content;
    }

    private String _formatSingleLineClauseWithMultiplePredicates(String fileName, String content) {
        Matcher matcher = this._singleLineClauseWitMultiplePredicatesPattern.matcher(content);
        while (matcher.find()) {
            String afterOperator = matcher.group(5);
            String beforeOperator = matcher.group(3);
            String indent = matcher.group(1);
            String match = matcher.group(2);
            String operator = matcher.group(4);
            StringBundler sb = new StringBundler(11);
            if (beforeOperator.equals(")")) {
                sb.append(") ");
                sb.append(operator);
                sb.append("\n");
                sb.append(indent);
                sb.append(afterOperator);
                return StringUtil.replaceFirst(content, match, sb.toString(), matcher.start());
            }
            int lineCount = this.getLineCount(content, matcher.start(3));
            if (this.getLevel(match) != 0 || !match.startsWith("(")) {
                this.addMessage(fileName, "One SQL predicate per line", lineCount);
                continue;
            }
            int beforeOperatorlevel = this.getLevel(beforeOperator);
            if (beforeOperatorlevel < 0 || beforeOperatorlevel > 1) {
                this.addMessage(fileName, "One SQL predicate per line", lineCount);
                continue;
            }
            if (beforeOperatorlevel == 0) {
                sb.append(beforeOperator);
                sb.append(" ");
                sb.append(operator);
                sb.append("\n");
                sb.append(indent);
                sb.append(afterOperator);
                return StringUtil.replaceFirst(content, match, sb.toString(), matcher.start());
            }
            sb.append("(\n\t");
            sb.append(indent);
            sb.append(beforeOperator.substring(1));
            sb.append(" ");
            sb.append(operator);
            sb.append("\n\t");
            sb.append(indent);
            int pos = afterOperator.lastIndexOf(")");
            sb.append(afterOperator.substring(0, pos));
            sb.append("\n");
            sb.append(indent);
            sb.append(afterOperator.substring(pos));
            return StringUtil.replaceFirst(content, match, sb.toString(), matcher.start());
        }
        return content;
    }

    private String _formatUnionStatement(String fileName, String content) {
        Matcher matcher = this._unionPattern.matcher(content);
        while (matcher.find()) {
            String beforeUnionChar = matcher.group(1);
            if (!beforeUnionChar.equals(")")) {
                this.addMessage(fileName, "Missing parentheses around SELECT statement", this.getLineCount(content, matcher.start()));
                continue;
            }
            int openParenthesisPos = this._getOpenParenthesisPos(content, matcher.start(1));
            String s = StringUtil.trim(content.substring(openParenthesisPos + 1, matcher.start()));
            if (!s.startsWith("SELECT")) {
                this.addMessage(fileName, "Missing parentheses around SELECT statement", this.getLineCount(content, matcher.start()));
                continue;
            }
            String afterUnionChar = matcher.group(4);
            if (!afterUnionChar.equals("(")) {
                this.addMessage(fileName, "Missing parentheses around SELECT statement", this.getLineCount(content, matcher.start(3)));
                continue;
            }
            String whitespace = matcher.group(2);
            if (!whitespace.contains("\n")) continue;
            return StringUtil.replaceFirst(content, whitespace, " ", matcher.start());
        }
        return content;
    }

    private int _getCloseParenthesisPos(String content, int startPos) {
        int endPos = startPos;
        while (this.getLevel(content.substring(startPos, (endPos = content.indexOf(")", endPos + 1)) + 1)) != 0) {
        }
        return endPos;
    }

    private int _getOpenParenthesisPos(String content, int endPos) {
        int startPos = endPos;
        while (this.getLevel(content.substring(startPos = content.lastIndexOf("(", startPos - 1), endPos + 1)) != 0) {
        }
        return startPos;
    }
}

