/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.File;

public class BNDSchemaVersionCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        this._checkMissingSchemaVersion(fileName, absolutePath, content);
        if (fileName.endsWith("-web/bnd.bnd") && content.contains("Liferay-Require-SchemaVersion: 1.0.0")) {
            this.addMessage(fileName, "Do not include the header Liferay-Require-SchemaVersion in web modules", "bnd_schema_version.markdown");
        }
        return content;
    }

    private void _checkMissingSchemaVersion(String fileName, String absolutePath, String content) {
        if (content.contains("Liferay-Require-SchemaVersion:") || !content.contains("Liferay-Service: true")) {
            return;
        }
        int pos = absolutePath.lastIndexOf(47);
        File serviceXMLfile = new File(absolutePath.substring(0, pos + 1) + "service.xml");
        if (serviceXMLfile.exists()) {
            this.addMessage(fileName, "Missing 'Liferay-Require-SchemaVersion'", "bnd_schema_version.markdown");
        }
    }
}

