/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.puppycrawl.tools.checkstyle.DetailNodeTreeStringPrinter;
import com.puppycrawl.tools.checkstyle.TreeWalker;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtils;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.regex.Pattern;

public final class AstTreeStringPrinter {
    private static final Pattern NEWLINE = Pattern.compile("\n");
    private static final Pattern RETURN = Pattern.compile("\r");
    private static final Pattern TAB = Pattern.compile("\t");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private AstTreeStringPrinter() {
    }

    public static String printFileAst(File file, PrintOptions withComments) throws IOException, CheckstyleException {
        return AstTreeStringPrinter.printTree(AstTreeStringPrinter.parseFile(file, withComments));
    }

    public static String printJavaAndJavadocTree(File file) throws IOException, CheckstyleException {
        DetailAST tree = AstTreeStringPrinter.parseFile(file, PrintOptions.WITH_COMMENTS);
        return AstTreeStringPrinter.printJavaAndJavadocTree(tree);
    }

    private static String printJavaAndJavadocTree(DetailAST ast) {
        StringBuilder messageBuilder = new StringBuilder(1024);
        for (DetailAST node = ast; node != null; node = node.getNextSibling()) {
            messageBuilder.append(AstTreeStringPrinter.getIndentation(node)).append(AstTreeStringPrinter.getNodeInfo(node)).append(LINE_SEPARATOR);
            if (node.getType() == 183 && JavadocUtils.isJavadocComment(node.getParent())) {
                String javadocTree = AstTreeStringPrinter.parseAndPrintJavadocTree(node);
                messageBuilder.append(javadocTree);
                continue;
            }
            messageBuilder.append(AstTreeStringPrinter.printJavaAndJavadocTree(node.getFirstChild()));
        }
        return messageBuilder.toString();
    }

    private static String parseAndPrintJavadocTree(DetailAST node) {
        DetailAST javadocBlock = node.getParent();
        DetailNode tree = DetailNodeTreeStringPrinter.parseJavadocAsDetailNode(javadocBlock);
        String baseIndentation = AstTreeStringPrinter.getIndentation(node);
        baseIndentation = baseIndentation.substring(0, baseIndentation.length() - 2);
        String rootPrefix = baseIndentation + "   `--";
        String prefix = baseIndentation + "       ";
        return DetailNodeTreeStringPrinter.printTree(tree, rootPrefix, prefix);
    }

    public static String printAst(FileText text, PrintOptions withComments) throws CheckstyleException {
        return AstTreeStringPrinter.printTree(AstTreeStringPrinter.parseFileText(text, withComments));
    }

    private static String printTree(DetailAST ast) {
        StringBuilder messageBuilder = new StringBuilder(1024);
        for (DetailAST node = ast; node != null; node = node.getNextSibling()) {
            messageBuilder.append(AstTreeStringPrinter.getIndentation(node)).append(AstTreeStringPrinter.getNodeInfo(node)).append(LINE_SEPARATOR).append(AstTreeStringPrinter.printTree(node.getFirstChild()));
        }
        return messageBuilder.toString();
    }

    private static String getNodeInfo(DetailAST node) {
        return TokenUtils.getTokenName(node.getType()) + " -> " + AstTreeStringPrinter.escapeAllControlChars(node.getText()) + " [" + node.getLineNo() + ':' + node.getColumnNo() + ']';
    }

    private static String getIndentation(DetailAST ast) {
        boolean isLastChild = ast.getNextSibling() == null;
        DetailAST node = ast;
        StringBuilder indentation = new StringBuilder(1024);
        while (node.getParent() != null) {
            if ((node = node.getParent()).getParent() == null) {
                if (isLastChild) {
                    indentation.append("`--");
                    continue;
                }
                indentation.append("|--");
                continue;
            }
            if (node.getNextSibling() == null) {
                indentation.insert(0, "    ");
                continue;
            }
            indentation.insert(0, "|   ");
        }
        return indentation.toString();
    }

    private static String escapeAllControlChars(String text) {
        String textWithoutNewlines = NEWLINE.matcher(text).replaceAll("\\\\n");
        String textWithoutReturns = RETURN.matcher(textWithoutNewlines).replaceAll("\\\\r");
        return TAB.matcher(textWithoutReturns).replaceAll("\\\\t");
    }

    private static DetailAST parseFile(File file, PrintOptions withComments) throws IOException, CheckstyleException {
        FileText text = new FileText(file.getAbsoluteFile(), System.getProperty("file.encoding", "UTF-8"));
        return AstTreeStringPrinter.parseFileText(text, withComments);
    }

    private static DetailAST parseFileText(FileText text, PrintOptions withComments) throws CheckstyleException {
        DetailAST result;
        FileContents contents = new FileContents(text);
        try {
            result = withComments == PrintOptions.WITH_COMMENTS ? TreeWalker.parseWithComments(contents) : TreeWalker.parse(contents);
        }
        catch (RecognitionException | TokenStreamException ex) {
            String exceptionMsg = String.format(Locale.ROOT, "%s occurred during the analysis of file %s.", ex.getClass().getSimpleName(), text.getFile().getPath());
            throw new CheckstyleException(exceptionMsg, ex);
        }
        return result;
    }

    public static enum PrintOptions {
        WITH_COMMENTS,
        WITHOUT_COMMENTS;

    }
}

