/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.TextBlock;

public class MissingAuthorCheck
extends BaseCheck {
    private static final String _MSG_MISSING_AUTHOR = "author.missing";

    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String[] javadocLines;
        DetailAST parentAST = detailAST.getParent();
        if (parentAST != null) {
            return;
        }
        FileContents fileContents = this.getFileContents();
        TextBlock javadoc = fileContents.getJavadocBefore(detailAST.getLineNo());
        if (javadoc == null) {
            this.log(detailAST.getLineNo(), _MSG_MISSING_AUTHOR, new Object[0]);
            return;
        }
        for (String javadocLine : javadocLines = javadoc.getText()) {
            if (!javadocLine.contains("@author ")) continue;
            return;
        }
        this.log(detailAST.getLineNo(), _MSG_MISSING_AUTHOR, new Object[0]);
    }
}

