/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.configuration.kernel.util;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.PortletSetupUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class PortletConfigurationUtil {
    public static String getPortletCustomCSSClassName(PortletPreferences portletSetup) throws Exception {
        JSONObject cssJSONObject;
        JSONObject advancedDataJSONObject;
        String customCSSClassName = "";
        String css = portletSetup.getValue("portletSetupCss", "");
        if (Validator.isNotNull(css) && (advancedDataJSONObject = (cssJSONObject = PortletSetupUtil.cssToJSONObject(portletSetup, css)).getJSONObject("advancedData")) != null) {
            customCSSClassName = advancedDataJSONObject.getString("customCSSClassName");
        }
        return customCSSClassName;
    }

    public static String getPortletTitle(PortletPreferences portletSetup, String languageId) {
        if (!PortletConfigurationUtil.isUseCustomTitle(portletSetup)) {
            return null;
        }
        return portletSetup.getValue("portletSetupTitle_" + languageId, null);
    }

    public static Map<Locale, String> getPortletTitleMap(PortletPreferences portletSetup) {
        if (!PortletConfigurationUtil.isUseCustomTitle(portletSetup)) {
            return null;
        }
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        boolean empty = true;
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            String portletTitle = GetterUtil.getString(PortletConfigurationUtil.getPortletTitle(portletSetup, LocaleUtil.toLanguageId(locale)));
            map.put(locale, portletTitle);
            if (!Validator.isNotNull(portletTitle)) continue;
            empty = false;
        }
        if (!empty) {
            return map;
        }
        return null;
    }

    protected static boolean isUseCustomTitle(PortletPreferences portletSetup) {
        return GetterUtil.getBoolean(portletSetup.getValue("portletSetupUseCustomTitle", null));
    }
}

