/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.util.GetterUtil;

public class BrowserMetadata {
    private static final String[] _FIREFOX_ALIASES = new String[]{"firefox", "minefield", "granparadiso", "bonecho", "firebird", "phoenix", "camino"};
    private static final String[] _WEBKIT_ALIASES = new String[]{"khtml", "applewebkit"};
    private static final String[] _WINDOWS_ALIASES = new String[]{"windows", "win32", "16bit"};
    private final String _userAgent;

    public BrowserMetadata(String userAgent) {
        this._userAgent = userAgent;
    }

    public boolean isAir() {
        return this._userAgent.contains("adobeair");
    }

    public boolean isAndroid() {
        return this._userAgent.contains("android");
    }

    public boolean isChrome() {
        if (this.isEdge()) {
            return false;
        }
        return this._userAgent.contains("chrome");
    }

    public boolean isEdge() {
        return this._userAgent.contains("edge");
    }

    public boolean isFirefox() {
        if (!this.isMozilla()) {
            return false;
        }
        for (String firefoxAlias : _FIREFOX_ALIASES) {
            if (!this._userAgent.contains(firefoxAlias)) continue;
            return true;
        }
        return false;
    }

    public boolean isGecko() {
        if (this.isEdge()) {
            return false;
        }
        return this._userAgent.contains("gecko");
    }

    public boolean isIe() {
        return (this._userAgent.contains("msie") || this._userAgent.contains("trident")) && !this._userAgent.contains("opera");
    }

    public boolean isIeOnWin32() {
        return this.isIe() && !this._userAgent.contains("wow64") && !this._userAgent.contains("win64");
    }

    public boolean isIeOnWin64() {
        return this.isIe() && (this._userAgent.contains("wow64") || this._userAgent.contains("win64"));
    }

    public boolean isIphone() {
        return this._userAgent.contains("iphone");
    }

    public boolean isLinux() {
        return this._userAgent.contains("linux");
    }

    public boolean isMac() {
        return this._userAgent.contains("mac");
    }

    public boolean isMobile() {
        return this._userAgent.contains("mobile") || this._userAgent.contains("android") && this._userAgent.contains("nexus");
    }

    public boolean isMozilla() {
        if (this.isEdge()) {
            return false;
        }
        if (this._userAgent.contains("compatible")) {
            return false;
        }
        if (this._userAgent.contains("webkit")) {
            return false;
        }
        return this._userAgent.contains("mozilla");
    }

    public boolean isOpera() {
        return this._userAgent.contains("opera");
    }

    public boolean isRtf(String version) {
        if (this.isAndroid()) {
            return true;
        }
        if (this.isChrome()) {
            return true;
        }
        if (this.isEdge()) {
            return true;
        }
        float majorVersion = GetterUtil.getFloat(version);
        if (this.isIe() && (double)majorVersion >= 5.5) {
            return true;
        }
        if (this.isMozilla() && (double)majorVersion >= 1.3) {
            return true;
        }
        if (this.isOpera()) {
            if (this.isMobile() && (double)majorVersion >= 10.0) {
                return true;
            }
            if (!this.isMobile()) {
                return true;
            }
        }
        if (this.isSafari()) {
            if (this.isMobile() && (double)majorVersion >= 5.0) {
                return true;
            }
            if (!this.isMobile() && (double)majorVersion >= 3.0) {
                return true;
            }
        }
        return false;
    }

    public boolean isSafari() {
        return this.isWebKit() && this._userAgent.contains("safari");
    }

    public boolean isSun() {
        return this._userAgent.contains("sunos");
    }

    public boolean isWebKit() {
        if (this.isEdge()) {
            return false;
        }
        for (String webKitAlias : _WEBKIT_ALIASES) {
            if (!this._userAgent.contains(webKitAlias)) continue;
            return true;
        }
        return false;
    }

    public boolean isWindows() {
        for (String windowsAlias : _WINDOWS_ALIASES) {
            if (!this._userAgent.contains(windowsAlias)) continue;
            return true;
        }
        return false;
    }
}

