/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.repository.capabilities;

import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.capabilities.CapabilityProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class BaseCapabilityProvider
implements CapabilityProvider {
    private final Set<Class<? extends Capability>> _exportedCapabilityClasses = new HashSet<Class<? extends Capability>>();
    private final Map<Class<? extends Capability>, Capability> _supportedCapabilities = new HashMap<Class<? extends Capability>, Capability>();

    public <S extends Capability> S getCapability(Class<S> capabilityClass) {
        if (this._exportedCapabilityClasses.contains(capabilityClass)) {
            S capability = this.getInternalCapability(capabilityClass);
            if (capability == null) {
                throw new IllegalArgumentException(String.format("Capability %s is not supported by provider %s", capabilityClass.getName(), this.getProviderKey()));
            }
            return capability;
        }
        throw new IllegalArgumentException(String.format("Capability %s is not exported by provider %s", capabilityClass.getName(), this.getProviderKey()));
    }

    public <S extends Capability> boolean isCapabilityProvided(Class<S> capabilityClass) {
        return this._exportedCapabilityClasses.contains(capabilityClass);
    }

    protected <S extends Capability> void addExportedCapability(Class<S> capabilityClass, S capability) {
        this.addSupportedCapability(capabilityClass, capability);
        this._exportedCapabilityClasses.add(capabilityClass);
    }

    protected <S extends Capability> void addSupportedCapability(Class<S> capabilityClass, S capability) {
        if (this._supportedCapabilities.containsKey(capabilityClass)) {
            throw new IllegalStateException("Capability " + capabilityClass.getName() + " already exists");
        }
        this._supportedCapabilities.put(capabilityClass, capability);
    }

    protected Map<Class<? extends Capability>, Capability> getCapabilities() {
        return this._supportedCapabilities;
    }

    protected <S extends Capability> S getInternalCapability(Class<S> capabilityClass) {
        return (S)this._supportedCapabilities.get(capabilityClass);
    }

    protected abstract String getProviderKey();
}

