/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.welder.fifo;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.File;

public class FIFOUtil {
    private static final boolean _FIFO_SUPPORTED;
    private static final Log _log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFIFO(File fifoFile) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder("mkfifo", fifoFile.getAbsolutePath());
        Process mkfifoProcess = null;
        try {
            mkfifoProcess = processBuilder.start();
            int result = mkfifoProcess.waitFor();
            if (result != 0) {
                throw new Exception("Unable to create FIFO with command \"mkfifo\", external process returned " + result);
            }
        }
        finally {
            if (mkfifoProcess != null) {
                mkfifoProcess.destroy();
            }
        }
    }

    public static boolean isFIFOSupported() {
        return _FIFO_SUPPORTED;
    }

    static {
        boolean fifoSupport;
        block7: {
            _log = LogFactoryUtil.getLog(FIFOUtil.class);
            fifoSupport = false;
            try {
                File tempFIFOFile = new File(System.getProperty("java.io.tmpdir"), "temp-fifo-" + System.currentTimeMillis());
                try {
                    FIFOUtil.createFIFO(tempFIFOFile);
                }
                finally {
                    if (!tempFIFOFile.delete() && tempFIFOFile.exists()) {
                        tempFIFOFile.deleteOnExit();
                    }
                }
                fifoSupport = true;
            }
            catch (Throwable t) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn("Unable to detect FIFO support", t);
            }
        }
        _FIFO_SUPPORTED = fifoSupport;
    }
}

