/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portlet.social.service.base.SocialRelationLocalServiceBaseImpl;
import com.liferay.social.kernel.exception.RelationUserIdException;
import com.liferay.social.kernel.model.SocialRelation;
import com.liferay.social.kernel.util.SocialRelationTypesUtil;
import java.util.List;

public class SocialRelationLocalServiceImpl
extends SocialRelationLocalServiceBaseImpl {
    public SocialRelation addRelation(long userId1, long userId2, int type) throws PortalException {
        SocialRelation biRelation;
        if (userId1 == userId2) {
            throw new RelationUserIdException();
        }
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        User user2 = this.userPersistence.findByPrimaryKey(userId2);
        if (user1.getCompanyId() != user2.getCompanyId()) {
            throw new RelationUserIdException();
        }
        SocialRelation relation = this.socialRelationPersistence.fetchByU1_U2_T(userId1, userId2, type);
        if (relation == null) {
            long relationId = this.counterLocalService.increment();
            relation = this.socialRelationPersistence.create(relationId);
            relation.setCompanyId(user1.getCompanyId());
            relation.setCreateDate(System.currentTimeMillis());
            relation.setUserId1(userId1);
            relation.setUserId2(userId2);
            relation.setType(type);
            this.socialRelationPersistence.update((BaseModel)relation);
        }
        if (SocialRelationTypesUtil.isTypeBi((int)type) && (biRelation = this.socialRelationPersistence.fetchByU1_U2_T(userId2, userId1, type)) == null) {
            long biRelationId = this.counterLocalService.increment();
            biRelation = this.socialRelationPersistence.create(biRelationId);
            biRelation.setCompanyId(user1.getCompanyId());
            biRelation.setCreateDate(System.currentTimeMillis());
            biRelation.setUserId1(userId2);
            biRelation.setUserId2(userId1);
            biRelation.setType(type);
            this.socialRelationPersistence.update((BaseModel)biRelation);
        }
        return relation;
    }

    public void deleteRelation(long relationId) throws PortalException {
        SocialRelation relation = this.socialRelationPersistence.findByPrimaryKey(relationId);
        this.deleteRelation(relation);
    }

    public void deleteRelation(long userId1, long userId2, int type) throws PortalException {
        SocialRelation relation = this.socialRelationPersistence.findByU1_U2_T(userId1, userId2, type);
        this.deleteRelation(relation);
    }

    public void deleteRelation(SocialRelation relation) throws PortalException {
        this.socialRelationPersistence.remove((BaseModel)relation);
        if (SocialRelationTypesUtil.isTypeBi((int)relation.getType())) {
            SocialRelation biRelation = this.socialRelationPersistence.findByU1_U2_T(relation.getUserId2(), relation.getUserId1(), relation.getType());
            this.socialRelationPersistence.remove((BaseModel)biRelation);
        }
    }

    public void deleteRelations(long userId) {
        this.socialRelationPersistence.removeByUserId1(userId);
        this.socialRelationPersistence.removeByUserId2(userId);
    }

    public void deleteRelations(long userId1, long userId2) throws PortalException {
        List relations = this.socialRelationPersistence.findByU1_U2(userId1, userId2);
        for (SocialRelation relation : relations) {
            this.deleteRelation(relation);
        }
    }

    public List<SocialRelation> getInverseRelations(long userId, int type, int start, int end) {
        return this.socialRelationPersistence.findByU2_T(userId, type, start, end);
    }

    public int getInverseRelationsCount(long userId, int type) {
        return this.socialRelationPersistence.countByU2_T(userId, type);
    }

    public SocialRelation getRelation(long relationId) throws PortalException {
        return this.socialRelationPersistence.findByPrimaryKey(relationId);
    }

    public SocialRelation getRelation(long userId1, long userId2, int type) throws PortalException {
        return this.socialRelationPersistence.findByU1_U2_T(userId1, userId2, type);
    }

    public List<SocialRelation> getRelations(long userId, int type, int start, int end) {
        return this.socialRelationPersistence.findByU1_T(userId, type, start, end);
    }

    public List<SocialRelation> getRelations(long userId1, long userId2, int start, int end) {
        return this.socialRelationPersistence.findByU1_U2(userId1, userId2, start, end);
    }

    public int getRelationsCount(long userId, int type) {
        return this.socialRelationPersistence.countByU1_T(userId, type);
    }

    public int getRelationsCount(long userId1, long userId2) {
        return this.socialRelationPersistence.countByU1_U2(userId1, userId2);
    }

    public boolean hasRelation(long userId1, long userId2, int type) {
        SocialRelation relation = this.socialRelationPersistence.fetchByU1_U2_T(userId1, userId2, type);
        return relation != null;
    }

    public boolean isRelatable(long userId1, long userId2, int type) {
        if (userId1 == userId2) {
            return false;
        }
        User user1 = this.userPersistence.fetchByPrimaryKey(userId1);
        if (user1 == null || user1.isDefaultUser()) {
            return false;
        }
        User user2 = this.userPersistence.fetchByPrimaryKey(userId2);
        if (user2 == null || user2.isDefaultUser()) {
            return false;
        }
        return !this.hasRelation(userId1, userId2, type);
    }
}

