/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0.util;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

public class RSSUtil {
    private static final String _FEED_TYPE_DEFAULT = GetterUtil.getString((String)PropsUtil.get((String)"rss.feed.type.default"), (String)"atom_1.0");

    public static String getFeedType(String type, double version) {
        return type + "_" + version;
    }

    public static String getFormatType(String format) {
        if (format == null) {
            return RSSUtil._getFeedTypeFormat(_FEED_TYPE_DEFAULT);
        }
        int x = format.indexOf("atom");
        if (x >= 0) {
            return "atom";
        }
        int y = format.indexOf("rss");
        if (y >= 0) {
            return "rss";
        }
        return RSSUtil._getFeedTypeFormat(_FEED_TYPE_DEFAULT);
    }

    public static double getFormatVersion(String format) {
        if (format == null) {
            return RSSUtil._getFeedTypeVersion(_FEED_TYPE_DEFAULT);
        }
        int x = format.indexOf("10");
        if (x >= 0) {
            return 1.0;
        }
        int y = format.indexOf("20");
        if (y >= 0) {
            return 2.0;
        }
        return RSSUtil._getFeedTypeVersion(_FEED_TYPE_DEFAULT);
    }

    private static String _getFeedTypeFormat(String feedType) {
        String[] parts;
        if (Validator.isNotNull((String)feedType) && (parts = StringUtil.split((String)feedType, (String)"_")).length == 2) {
            return GetterUtil.getString((String)parts[0], (String)RSSUtil._getFeedTypeFormat(_FEED_TYPE_DEFAULT));
        }
        return RSSUtil._getFeedTypeFormat(_FEED_TYPE_DEFAULT);
    }

    private static double _getFeedTypeVersion(String feedType) {
        String[] parts;
        if (Validator.isNotNull((String)feedType) && (parts = StringUtil.split((String)feedType, (String)"_")).length == 2) {
            return GetterUtil.getDouble((String)parts[1], (double)RSSUtil._getFeedTypeVersion(_FEED_TYPE_DEFAULT));
        }
        return RSSUtil._getFeedTypeVersion(_FEED_TYPE_DEFAULT);
    }
}

