/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.aop.ServiceBeanAopProxy;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.target.SingletonTargetSource;

public class ServiceWrapperProxyUtil {
    public static Closeable createProxy(Object springServiceProxy, Class<?> serviceWrapperClass) throws Exception {
        if (!ProxyUtil.isProxyClass(springServiceProxy.getClass())) {
            throw new IllegalArgumentException(springServiceProxy + " is not a Spring service proxy");
        }
        final AdvisedSupport advisedSupport = ServiceBeanAopProxy.getAdvisedSupport(springServiceProxy);
        final TargetSource targetSource = advisedSupport.getTargetSource();
        final Object previousService = targetSource.getTarget();
        Constructor<?>[] constructors = serviceWrapperClass.getDeclaredConstructors();
        Constructor<?> constructor = constructors[0];
        constructor.setAccessible(true);
        advisedSupport.setTargetSource((TargetSource)new SingletonTargetSource(constructor.newInstance(previousService)));
        return new Closeable(){

            @Override
            public void close() throws IOException {
                advisedSupport.setTargetSource(targetSource);
                try {
                    targetSource.releaseTarget(previousService);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        };
    }

    public static Closeable injectFieldProxy(Object springServiceProxy, String fieldName, Class<?> wrapperClass) throws Exception {
        if (!ProxyUtil.isProxyClass(springServiceProxy.getClass())) {
            throw new IllegalArgumentException(springServiceProxy + " is not a Spring service proxy");
        }
        AdvisedSupport advisedSupport = ServiceBeanAopProxy.getAdvisedSupport(springServiceProxy);
        TargetSource targetSource = advisedSupport.getTargetSource();
        final Object targetService = targetSource.getTarget();
        Field field = null;
        for (Class<?> clazz = targetService.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                field = ReflectionUtil.getDeclaredField(clazz, (String)fieldName);
                break;
            }
            catch (NoSuchFieldException nsfe) {
                continue;
            }
        }
        if (field == null) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Unable to locate field ", fieldName, " in ", String.valueOf(targetService)}));
        }
        final Field finalField = field;
        final Object previousValue = finalField.get(targetService);
        Constructor<?>[] constructors = wrapperClass.getDeclaredConstructors();
        Constructor<?> constructor = constructors[0];
        constructor.setAccessible(true);
        finalField.set(targetService, constructor.newInstance(previousValue));
        return new Closeable(){

            @Override
            public void close() throws IOException {
                try {
                    finalField.set(targetService, previousValue);
                }
                catch (ReflectiveOperationException roe) {
                    throw new IOException(roe);
                }
            }
        };
    }
}

