/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.header;

import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PropsValues;
import java.text.Format;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class HeaderFilter
extends BasePortalFilter {
    private static final Format _dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"EEE, dd MMM yyyy HH:mm:ss Z", (Locale)LocaleUtil.US, (TimeZone)TimeZoneUtil.GMT);
    private static final Set<String> _requestHeaderIgnoreInitParams = SetUtil.fromArray((Object[])PropsValues.REQUEST_HEADER_IGNORE_INIT_PARAMS);

    protected long getLastModified(HttpServletRequest request) {
        String value = HttpUtil.getParameter((String)request.getQueryString(), (String)"t");
        if (Validator.isNull((String)value)) {
            return -1L;
        }
        return GetterUtil.getLong((String)value);
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        FilterConfig filterConfig = this.getFilterConfig();
        Enumeration enu = filterConfig.getInitParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (_requestHeaderIgnoreInitParams.contains(name)) continue;
            this._addHeader(request, response, name, filterConfig.getInitParameter(name));
        }
        long lastModified = this.getLastModified(request);
        if (lastModified > 0L) {
            long ifModifiedSince = request.getDateHeader("If-Modified-Since");
            response.setDateHeader("Last-Modified", lastModified);
            if (lastModified <= ifModifiedSince) {
                response.setDateHeader("Last-Modified", ifModifiedSince);
                response.setStatus(304);
                return;
            }
        }
        this.processFilter(HeaderFilter.class.getName(), request, response, filterChain);
    }

    private void _addHeader(HttpServletRequest request, HttpServletResponse response, String name, String value) {
        if (StringUtil.equalsIgnoreCase((String)name, (String)"Cache-Control")) {
            if (this._isNewSession(request)) {
                String contextPath;
                if (value.contains("public")) {
                    return;
                }
                if (PropsValues.WEB_SERVER_PROXY_LEGACY_MODE && (contextPath = request.getContextPath()).equals(PortalUtil.getPathContext())) {
                    return;
                }
            }
        } else if (StringUtil.equalsIgnoreCase((String)name, (String)"Expires")) {
            if (this._isNewSession(request)) {
                return;
            }
            if (Validator.isNumber((String)value)) {
                int seconds = GetterUtil.getInteger((String)value);
                value = _dateFormat.format(System.currentTimeMillis() + (long)seconds * 1000L);
            }
        }
        response.addHeader(name, value);
    }

    private boolean _isNewSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return session == null || session.isNew();
    }
}

