/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JasperVersionDetector {
    private static final Log _log = LogFactoryUtil.getLog(JasperVersionDetector.class);
    private static final JasperVersionDetector _instance = new JasperVersionDetector();
    private String _jasperVersion = "";
    private boolean _jspServletDependantsMap;

    public static String getJasperVersion() {
        return JasperVersionDetector._instance._jasperVersion;
    }

    public static boolean hasJspServletDependantsMap() {
        return JasperVersionDetector._instance._jspServletDependantsMap;
    }

    private JasperVersionDetector() {
        this._initializeJasperVersion();
        this._initializeJspServletDependantsMap();
    }

    private void _initializeJasperVersion() {
        Class<?> clazz = this.getClass();
        URL url = clazz.getResource("/org/apache/jasper/JasperException.class");
        if (url == null) {
            return;
        }
        String path = url.getPath();
        int pos = path.indexOf(33);
        if (pos == -1) {
            return;
        }
        try (JarFile jarFile = new JarFile(new File(new URI(path.substring(0, pos))));){
            Attributes.Name bundleVersionAttributesName;
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            if (attributes.containsKey(Attributes.Name.SPECIFICATION_VERSION)) {
                this._jasperVersion = GetterUtil.getString((String)attributes.getValue(Attributes.Name.SPECIFICATION_VERSION));
                if (this._isValidJasperVersion(this._jasperVersion)) {
                    return;
                }
            }
            if (attributes.containsKey(Attributes.Name.IMPLEMENTATION_VERSION)) {
                this._jasperVersion = GetterUtil.getString((Object)attributes.get(Attributes.Name.IMPLEMENTATION_VERSION));
                if (this._isValidJasperVersion(this._jasperVersion)) {
                    return;
                }
            }
            if (attributes.containsKey(bundleVersionAttributesName = new Attributes.Name("Bundle-Version"))) {
                this._jasperVersion = GetterUtil.getString((Object)attributes.get(bundleVersionAttributesName));
                if (this._isValidJasperVersion(this._jasperVersion)) {
                    return;
                }
                this._jasperVersion = "";
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    private void _initializeJspServletDependantsMap() {
        try {
            Class<?> clazz = Class.forName("org.apache.jasper.servlet.JspServletWrapper");
            Method method = ReflectionUtil.getDeclaredMethod(clazz, (String)"getDependants", (Class[])new Class[0]);
            Class<?> returnType = method.getReturnType();
            this._jspServletDependantsMap = Map.class.isAssignableFrom(returnType);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    private boolean _isValidJasperVersion(String jasperVersion) {
        return !Validator.isNull((String)jasperVersion) && Validator.isDigit((char)jasperVersion.charAt(0));
    }
}

