/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.servlet.DirectServletRegistry;
import com.liferay.portal.servlet.JasperVersionDetector;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

@DoPrivileged
public class DirectServletRegistryImpl
implements DirectServletRegistry {
    private static final Log _log = LogFactoryUtil.getLog(DirectServletRegistryImpl.class);
    private final Map<String, Long> _dependantTimestamps = new ConcurrentHashMap<String, Long>();
    private boolean _reloadDependants = true;
    private final Map<String, ServletInfo> _servletInfos = new ConcurrentHashMap<String, ServletInfo>();

    public void clearServlets() {
        this._servletInfos.clear();
    }

    public Servlet getServlet(String path) {
        ServletInfo servletInfo = this._servletInfos.get(path);
        if (servletInfo == null) {
            return null;
        }
        Servlet servlet = servletInfo.getServlet();
        if (PropsValues.DIRECT_SERVLET_CONTEXT_RELOAD) {
            long lastModified = this.getFileLastModified(path, servlet);
            if (lastModified == 0L || lastModified != servletInfo.getLastModified()) {
                this._servletInfos.remove(path);
                servlet = null;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Reload " + path));
                }
            } else {
                servlet = this.reloadDependants(path, servlet, servletInfo);
            }
        }
        return servlet;
    }

    public void putServlet(String path, Servlet servlet) {
        if (this._servletInfos.containsKey(path)) {
            return;
        }
        long lastModified = 1L;
        if (PropsValues.DIRECT_SERVLET_CONTEXT_RELOAD) {
            lastModified = this.getFileLastModified(path, servlet);
        }
        if (lastModified > 0L) {
            ServletInfo servletInfo = new ServletInfo();
            servletInfo.setLastModified(lastModified);
            servletInfo.setServlet(servlet);
            this._servletInfos.put(path, servletInfo);
        }
    }

    protected long getFileLastModified(String path, Servlet servlet) {
        ServletConfig servletConfig = servlet.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        String rootPath = servletContext.getRealPath("");
        File file = new File(rootPath, path);
        if (file.exists()) {
            return file.lastModified();
        }
        return -1L;
    }

    protected Servlet reloadDependants(String path, Servlet servlet, ServletInfo servletInfo) {
        if (!this._reloadDependants) {
            return servlet;
        }
        try {
            Method method = ReflectionUtil.getDeclaredMethod(servlet.getClass(), (String)"getDependants", (Class[])new Class[0]);
            Collection<Object> dependants = null;
            if (JasperVersionDetector.hasJspServletDependantsMap()) {
                Map dependantsMap = (Map)method.invoke((Object)servlet, new Object[0]);
                if (dependantsMap != null) {
                    dependants = dependantsMap.keySet();
                }
            } else {
                dependants = (List)method.invoke((Object)servlet, new Object[0]);
            }
            if (dependants == null) {
                return servlet;
            }
            boolean reloadServlet = false;
            for (String string : dependants) {
                long lastModified = this.getFileLastModified(string, servlet);
                Long previousLastModified = this._dependantTimestamps.get(string);
                if (previousLastModified == null) {
                    this._dependantTimestamps.put(string, lastModified);
                    previousLastModified = lastModified;
                }
                if (lastModified != 0L && lastModified == previousLastModified) continue;
                reloadServlet = true;
                this._dependantTimestamps.put(string, lastModified);
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Reload dependant " + string));
            }
            if (reloadServlet) {
                this._servletInfos.remove(path);
                this.updateFileLastModified(path, servlet);
                servlet = null;
            }
        }
        catch (NoSuchMethodException nsme) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Reloading of dependant JSP is disabled because your Servlet container is not a variant of Jasper");
            }
            this._reloadDependants = false;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return servlet;
    }

    protected void updateFileLastModified(String path, Servlet servlet) {
        ServletConfig servletConfig = servlet.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        String rootPath = servletContext.getRealPath("");
        File file = new File(rootPath, path);
        file.setLastModified(System.currentTimeMillis());
    }

    private static class ServletInfo {
        private long _lastModified;
        private Servlet _servlet;

        private ServletInfo() {
        }

        public long getLastModified() {
            return this._lastModified;
        }

        public Servlet getServlet() {
            return this._servlet;
        }

        public void setLastModified(long lastModified) {
            this._lastModified = lastModified;
        }

        public void setServlet(Servlet servlet) {
            this._servlet = servlet;
        }
    }
}

