/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.plugin;

import com.liferay.portal.kernel.plugin.License;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.background.task.ReindexStatusMessageSenderUtil;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.plugin.ModuleId;
import com.liferay.portal.plugin.PluginPackageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

@OSGiBeanProperties
public class PluginPackageIndexer
extends BaseIndexer<PluginPackage> {
    public static final String CLASS_NAME = PluginPackage.class.getName();

    public PluginPackageIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "content", "entryClassName", "entryClassPK", "title", "uid"});
        this.setStagingAware(false);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    protected void doDelete(PluginPackage pluginPackage) throws Exception {
        this.deleteDocument(0L, pluginPackage.getModuleId());
    }

    protected Document doGetDocument(PluginPackage pluginPackage) throws Exception {
        DocumentImpl document = new DocumentImpl();
        document.addUID(CLASS_NAME, pluginPackage.getModuleId());
        document.addKeyword("companyId", 0L);
        StringBundler sb = new StringBundler(7);
        sb.append(pluginPackage.getAuthor());
        sb.append(" ");
        String longDescription = HtmlUtil.extractText((String)pluginPackage.getLongDescription());
        sb.append(longDescription);
        sb.append(" ");
        sb.append(pluginPackage.getName());
        sb.append(" ");
        String shortDescription = HtmlUtil.extractText((String)pluginPackage.getShortDescription());
        sb.append(shortDescription);
        document.addText("content", sb.toString());
        document.addKeyword("entryClassName", PluginPackage.class.getName());
        ModuleId moduleIdObj = ModuleId.getInstance(pluginPackage.getModuleId());
        document.addKeyword("groupId", moduleIdObj.getGroupId());
        document.addDate("modified", pluginPackage.getModifiedDate());
        String[] statusAndInstalledVersion = PluginPackageUtil.getStatusAndInstalledVersion(pluginPackage);
        document.addKeyword("status", statusAndInstalledVersion[0]);
        document.addText("title", pluginPackage.getName());
        document.addKeyword("artifactId", moduleIdObj.getArtifactId());
        document.addText("author", pluginPackage.getAuthor());
        document.addText("changeLog", pluginPackage.getChangeLog());
        document.addKeyword("installedVersion", statusAndInstalledVersion[1]);
        List licenses = pluginPackage.getLicenses();
        document.addKeyword("license", (String[])ListUtil.toArray((List)licenses, (Accessor)License.NAME_ACCESSOR));
        document.addText("longDescription", longDescription);
        document.addKeyword("moduleId", pluginPackage.getModuleId());
        boolean osiLicense = false;
        for (License license : licenses) {
            if (!license.isOsiApproved()) continue;
            osiLicense = true;
            break;
        }
        document.addKeyword("osi-approved-license", osiLicense);
        document.addText("pageURL", pluginPackage.getPageURL());
        document.addKeyword("repositoryURL", pluginPackage.getRepositoryURL());
        document.addText("shortDescription", shortDescription);
        List tags = pluginPackage.getTags();
        document.addKeyword("tag", tags.toArray(new String[tags.size()]));
        List types = pluginPackage.getTypes();
        document.addKeyword("type", types.toArray(new String[types.size()]));
        document.addKeyword("version", pluginPackage.getVersion());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("content"), (int)200);
        }
        return new Summary(title, content);
    }

    protected void doReindex(PluginPackage pluginPackage) throws Exception {
        Document document = this.getDocument(pluginPackage);
        IndexWriterHelperUtil.updateDocument((String)this.getSearchEngineId(), (long)0L, (Document)document, (boolean)this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
    }

    protected void doReindex(String[] ids) throws Exception {
        IndexWriterHelperUtil.deleteEntityDocuments((String)this.getSearchEngineId(), (long)0L, (String)CLASS_NAME, (boolean)this.isCommitImmediately());
        ArrayList<Document> documents = new ArrayList<Document>();
        List<PluginPackage> pluginPackages = PluginPackageUtil.getAllAvailablePluginPackages();
        int total = pluginPackages.size();
        ReindexStatusMessageSenderUtil.sendStatusMessage((String)this.getClassName(), (long)0L, (long)total);
        for (PluginPackage pluginPackage : pluginPackages) {
            Document document = this.getDocument(pluginPackage);
            documents.add(document);
        }
        IndexWriterHelperUtil.updateDocuments((String)this.getSearchEngineId(), (long)0L, documents, (boolean)this.isCommitImmediately());
        ReindexStatusMessageSenderUtil.sendStatusMessage((String)this.getClassName(), (long)total, (long)total);
    }

    protected void postProcessFullQuery(BooleanQuery fullQuery, SearchContext searchContext) throws Exception {
        String status;
        String license;
        String repositoryURL;
        String tag;
        String type;
        BooleanFilter booleanFilter = fullQuery.getPreBooleanFilter();
        if (booleanFilter == null) {
            booleanFilter = new BooleanFilter();
        }
        if (Validator.isNotNull((String)(type = (String)((Object)searchContext.getAttribute("type"))))) {
            booleanFilter.addRequiredTerm("type", type);
        }
        if (Validator.isNotNull((String)(tag = (String)((Object)searchContext.getAttribute("tag"))))) {
            booleanFilter.addRequiredTerm("tag", tag);
        }
        if (Validator.isNotNull((String)(repositoryURL = (String)((Object)searchContext.getAttribute("repositoryURL"))))) {
            booleanFilter.addRequiredTerm("repositoryURL", repositoryURL);
        }
        if (Validator.isNotNull((String)(license = (String)((Object)searchContext.getAttribute("license"))))) {
            booleanFilter.addRequiredTerm("license", license);
        }
        if (Validator.isNull((String)(status = (String)((Object)searchContext.getAttribute("status")))) || status.equals("all")) {
            return;
        }
        if (status.equals("notInstalledOrOlderVersionInstalled")) {
            BooleanFilter statusBooleanFilter = new BooleanFilter();
            statusBooleanFilter.addTerm("status", "notInstalled");
            statusBooleanFilter.addTerm("status", "olderVersionInstalled");
            booleanFilter.add((Filter)statusBooleanFilter, BooleanClauseOccur.MUST);
        } else {
            booleanFilter.addRequiredTerm("status", status);
        }
        if (booleanFilter.hasClauses()) {
            fullQuery.setPreBooleanFilter(booleanFilter);
        }
    }
}

